/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.exceptions.ModelRequestException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ModelObjectAutoFactory<T, K>
implements ModelObjectFactory<T, K> {
    private final Constructor<T> fConstructor;

    public ModelObjectAutoFactory(Class<T> clazz) throws ModelRequestException {
        try {
            this.fConstructor = clazz.getConstructor(ModelObjectFactory.ObjectCreateContext.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ModelRequestException("ModelObjectAutoFactory couldn't locate a constructor for " + clazz.getCanonicalName() + " with param " + ModelObjectFactory.ObjectCreateContext.class.getCanonicalName(), e);
        }
    }

    @Override
    public T create(ModelObjectFactory.ObjectCreateContext<K> data) throws ModelRequestException {
        try {
            return this.fConstructor.newInstance(data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException x) {
            throw new ModelRequestException(x);
        }
    }
}

