/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.services.model.core.ModelItemFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface ModelItemList<T>
extends Iterable<T> {
    default public ModelItemList<T> filter(ModelItemFilter<T> mof) {
        final LinkedList result = new LinkedList();
        for (Object mo : this) {
            if (!mof.matches(mo)) continue;
            result.add(mo);
        }
        return new ModelItemList<T>(){

            @Override
            public Iterator<T> iterator() {
                return result.iterator();
            }
        };
    }

    public static <T> ModelItemList<T> simpleListOfCollection(final Collection<T> instances) {
        return new ModelItemList<T>(){

            @Override
            public Iterator<T> iterator() {
                return instances.iterator();
            }
        };
    }

    public static <T> List<T> iterateIntoList(ModelItemList<T> list) {
        LinkedList result = new LinkedList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}

