/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.builder.Builder;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.identity.Identity;
import io.continual.services.Service;
import io.continual.services.model.core.ModelCapabilities;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObjectAutoFactory;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelSchemaViolationException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Path;
import java.io.Closeable;

public interface Model
extends ModelCapabilities,
Closeable,
Service {
    public String getId();

    public ModelRequestContextBuilder getRequestContextBuilder();

    public boolean exists(ModelRequestContext var1, Path var2) throws ModelServiceException, ModelRequestException;

    default public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path parentPath) throws ModelServiceException, ModelItemDoesNotExistException, ModelRequestException {
        return this.listChildrenOfPath(context, parentPath, new PageRequest());
    }

    public ModelPathListPage listChildrenOfPath(ModelRequestContext var1, Path var2, PageRequest var3) throws ModelServiceException, ModelItemDoesNotExistException, ModelRequestException;

    public ModelQuery startQuery() throws ModelRequestException, ModelServiceException;

    public ModelTraversal startTraversal() throws ModelRequestException;

    public Model createIndex(String var1) throws ModelRequestException, ModelServiceException;

    default public BasicModelObject load(ModelRequestContext context, Path objectPath) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.load(context, objectPath, BasicModelObject.class);
    }

    default public <T> T load(ModelRequestContext context, Path objectPath, Class<T> clazz) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.load(context, objectPath, new ModelObjectAutoFactory(clazz), null);
    }

    default public <T, K> T load(ModelRequestContext context, Path objectPath, Class<T> clazz, K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.load(context, objectPath, new ModelObjectAutoFactory(clazz), userContext);
    }

    public <T, K> T load(ModelRequestContext var1, Path var2, ModelObjectFactory<T, K> var3, K var4) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException;

    public ObjectUpdater createUpdate(ModelRequestContext var1, Path var2) throws ModelRequestException, ModelServiceException;

    public boolean remove(ModelRequestContext var1, Path var2) throws ModelServiceException, ModelRequestException;

    public Model setRelationType(ModelRequestContext var1, String var2, RelationType var3) throws ModelServiceException, ModelRequestException;

    public ModelRelationInstance relate(ModelRequestContext var1, ModelRelation var2) throws ModelServiceException, ModelRequestException;

    public boolean unrelate(ModelRequestContext var1, ModelRelation var2) throws ModelServiceException, ModelRequestException;

    default public boolean unrelate(ModelRequestContext context, ModelRelationInstance reln) throws ModelServiceException, ModelRequestException {
        return this.unrelate(context, reln.getId());
    }

    public boolean unrelate(ModelRequestContext var1, String var2) throws ModelServiceException, ModelRequestException;

    public RelationSelector selectRelations(Path var1);

    public static interface RelationSelector {
        default public RelationSelector withAnyName() {
            return this.named(null);
        }

        public RelationSelector named(String var1);

        default public RelationSelector inboundOnly() {
            return this.inbound(true).outbound(false);
        }

        public RelationSelector inbound(boolean var1);

        default public RelationSelector outboundOnly() {
            return this.inbound(false).outbound(true);
        }

        public RelationSelector outbound(boolean var1);

        default public RelationSelector inboundAndOutbound() {
            return this.inbound(true).outbound(true);
        }

        public ModelRelationList getRelations(ModelRequestContext var1) throws ModelServiceException, ModelRequestException;
    }

    public static enum RelationType {
        UNORDERED,
        ORDERED;

    }

    public static interface ObjectUpdater {
        public ObjectUpdater replaceAcl(AccessControlList var1);

        @Deprecated
        default public ObjectUpdater overwrite(ModelObject withData) {
            return this.overwriteData(withData);
        }

        public ObjectUpdater overwriteData(ModelObject var1);

        @Deprecated
        default public ObjectUpdater merge(ModelObject withData) {
            return this.mergeData(withData);
        }

        public ObjectUpdater mergeData(ModelObject var1);

        public ObjectUpdater addTypeLock(String var1);

        public ObjectUpdater removeTypeLock(String var1);

        public void execute() throws ModelRequestException, ModelSchemaViolationException, ModelServiceException;
    }

    public static interface ModelRequestContextBuilder {
        public ModelRequestContextBuilder forSimpleIdentity(String var1);

        public ModelRequestContextBuilder forUser(Identity var1);

        public ModelRequestContextBuilder withSchemasFrom(ModelSchemaRegistry var1);

        public ModelRequestContextBuilder withNotificationsTo(ModelNotificationService var1);

        public ModelRequestContext build() throws Builder.BuildFailure;
    }
}

