/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.client;

import io.continual.builder.Builder;
import io.continual.iam.identity.Identity;
import io.continual.services.model.client.ModelObjectWriter;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectAndPath;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRelationList;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.subpathWrapper.SubpathWrapperModel;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.Iterator;

public class ModelConnection {
    private final Model fModel;
    private final Identity fOperator;
    private final ModelRequestContext fContext;

    public ModelConnection atSubpath(Path subpath) throws Builder.BuildFailure {
        return new Builder().withModel(this.fModel).operatedBy(this.fOperator).atSubPath(subpath).build();
    }

    public String getId() {
        return this.fModel.getId();
    }

    public Identity getOperator() {
        return this.fOperator;
    }

    public long getMaxPathLength() {
        return this.fModel.getMaxPathLength();
    }

    public long getMaxRelnNameLength() {
        return this.fModel.getMaxRelnNameLength();
    }

    public long getMaxSerializedObjectLength() {
        return this.fModel.getMaxSerializedObjectLength();
    }

    public void close() throws IOException {
        this.fModel.close();
    }

    public boolean exists(Path objectPath) throws ModelServiceException, ModelRequestException {
        return this.fModel.exists(this.fContext, objectPath);
    }

    public ModelPathListPage listChildrenOfPath(Path parentPath) throws ModelServiceException, ModelItemDoesNotExistException, ModelRequestException {
        return this.fModel.listChildrenOfPath(this.fContext, parentPath);
    }

    public ModelPathListPage listChildrenOfPath(Path parentPath, PageRequest pr) throws ModelServiceException, ModelItemDoesNotExistException, ModelRequestException {
        return this.fModel.listChildrenOfPath(this.fContext, parentPath, pr);
    }

    public ModelQuery startQuery() throws ModelRequestException, ModelServiceException {
        return this.fModel.startQuery();
    }

    public ModelTraversal startTraversal() throws ModelRequestException {
        return this.fModel.startTraversal();
    }

    public ModelConnection createIndex(String field) throws ModelRequestException, ModelServiceException {
        this.fModel.createIndex(field);
        return this;
    }

    public BasicModelObject load(Path objectPath) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.fModel.load(this.fContext, objectPath);
    }

    public <T> T load(Path objectPath, Class<T> clazz) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.fModel.load(this.fContext, objectPath, clazz);
    }

    public <T, K> T load(Path objectPath, Class<T> clazz, K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.fModel.load(this.fContext, objectPath, clazz, userContext);
    }

    public <T, K> T load(Path objectPath, ModelObjectFactory<T, K> factory, K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        return this.fModel.load(this.fContext, objectPath, factory, userContext);
    }

    public <T extends ModelObjectWriter> void store(Path objPath, T obj) throws ModelRequestException, ModelServiceException {
        JsonModelObject data = new JsonModelObject();
        obj.serializeTo(data);
        this.createUpdate(objPath).overwriteData(data).execute();
    }

    public Model.ObjectUpdater createUpdate(Path objectPath) throws ModelRequestException, ModelServiceException {
        return this.fModel.createUpdate(this.fContext, objectPath);
    }

    public boolean remove(Path objectPath) throws ModelServiceException, ModelRequestException {
        return this.fModel.remove(this.fContext, objectPath);
    }

    public ModelConnection setRelationType(String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        this.fModel.setRelationType(this.fContext, relnName, rt);
        return this;
    }

    public ModelRelationInstance relate(ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fModel.relate(this.fContext, reln);
    }

    public boolean unrelate(ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fModel.unrelate(this.fContext, reln);
    }

    public boolean unrelate(String relnId) throws ModelServiceException, ModelRequestException {
        return this.fModel.unrelate(this.fContext, relnId);
    }

    public RelationSelector selectRelations(final Path objectPath) {
        final ModelConnection mc = this;
        final Model.RelationSelector mrs = this.fModel.selectRelations(objectPath);
        return new RelationSelector(){

            @Override
            public RelationSelector named(String name) {
                mrs.named(name);
                return this;
            }

            @Override
            public RelationSelector inbound(boolean wantInbound) {
                mrs.inbound(wantInbound);
                return this;
            }

            @Override
            public RelationSelector outbound(boolean wantOutbound) {
                mrs.outbound(wantOutbound);
                return this;
            }

            @Override
            public ModelRelationList getRelations() throws ModelServiceException, ModelRequestException {
                return mrs.getRelations(ModelConnection.this.fContext);
            }

            @Override
            public ModelObjectList<RelationSelector.Loadable> getRelatedObjects() throws ModelServiceException, ModelRequestException {
                ModelRelationList relns = this.getRelations();
                final Iterator iter = relns.iterator();
                return new ModelObjectList<RelationSelector.Loadable>(){

                    @Override
                    public Iterator<ModelObjectAndPath<RelationSelector.Loadable>> iterator() {
                        return new Iterator<ModelObjectAndPath<RelationSelector.Loadable>>(){

                            @Override
                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            @Override
                            public ModelObjectAndPath<RelationSelector.Loadable> next() {
                                ModelRelationInstance mri = (ModelRelationInstance)iter.next();
                                final Path farEnd = mri.getFrom().equals((Object)objectPath) ? mri.getTo() : mri.getFrom();
                                return new ModelObjectAndPath<RelationSelector.Loadable>(){

                                    @Override
                                    public Path getPath() {
                                        return farEnd;
                                    }

                                    @Override
                                    public RelationSelector.Loadable getObject() {
                                        return new RelationSelector.Loadable(){

                                            @Override
                                            public <T, K> T load(Class<T> clazz, K userContext) throws ModelServiceException, ModelRequestException {
                                                return mc.load(farEnd, clazz, userContext);
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    private ModelConnection(Builder b) throws Builder.BuildFailure {
        this.fOperator = b.fOperator;
        this.fModel = b.fSubPath.isRootPath() ? b.fModel : new SubpathWrapperModel(b.fModel, b.fSubPath, b.fModel.getId());
        this.fContext = this.fModel.getRequestContextBuilder().forUser(this.fOperator).build();
    }

    public static class Builder {
        private Model fModel = null;
        private Identity fOperator = null;
        private Path fSubPath = Path.getRootPath();

        public Builder withModel(Model m) {
            this.fModel = m;
            return this;
        }

        public Builder operatedBy(Identity i) {
            this.fOperator = i;
            return this;
        }

        public Builder atSubPath(Path p) {
            this.fSubPath = p;
            return this;
        }

        public ModelConnection build() throws Builder.BuildFailure {
            return new ModelConnection(this);
        }
    }

    public static interface RelationSelector {
        default public RelationSelector withAnyName() {
            return this.named(null);
        }

        public RelationSelector named(String var1);

        default public RelationSelector inboundOnly() {
            return this.inbound(true).outbound(false);
        }

        public RelationSelector inbound(boolean var1);

        default public RelationSelector outboundOnly() {
            return this.inbound(false).outbound(true);
        }

        public RelationSelector outbound(boolean var1);

        default public RelationSelector inboundAndOutbound() {
            return this.inbound(true).outbound(true);
        }

        public ModelRelationList getRelations() throws ModelServiceException, ModelRequestException;

        public ModelObjectList<Loadable> getRelatedObjects() throws ModelServiceException, ModelRequestException;

        public static interface Loadable {
            default public BasicModelObject load() throws ModelServiceException, ModelRequestException {
                return this.load(BasicModelObject.class);
            }

            default public <T> T load(Class<T> clazz) throws ModelServiceException, ModelRequestException {
                return this.load(clazz, null);
            }

            public <T, K> T load(Class<T> var1, K var2) throws ModelServiceException, ModelRequestException;
        }
    }
}

