/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.time;

import io.continual.util.data.StringUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clock {
    static final String skTimeStartMs = "continualClockStartMs";
    static final String skTimeScaleArg = "continualClockScale";
    private static final Logger log = LoggerFactory.getLogger(Clock.class);

    public static long now() {
        return holder.instance.nowMs();
    }

    public static void replaceClock(Clock c) {
        holder.instance = c;
    }

    public static TestClock useNewTestClock() {
        TestClock tc = new TestClock();
        Clock.replaceClock(tc);
        return tc;
    }

    protected long nowMs() {
        return System.currentTimeMillis();
    }

    private static class holder {
        static volatile Clock instance = StringUtils.isNotEmpty(System.getProperty("continualClockStartMs")) || StringUtils.isNotEmpty(System.getProperty("continualClockScale")) ? new ScaledClock() : new Clock();

        private holder() {
        }
    }

    public static class TestClock
    extends Clock {
        private long nowMs = 1L;

        @Override
        public long nowMs() {
            return this.nowMs;
        }

        public TestClock set(long ms) {
            this.nowMs = ms;
            return this;
        }

        public TestClock add(long ms) {
            this.nowMs += ms;
            return this;
        }

        public TestClock add(long val, TimeUnit tu) {
            return this.add(TimeUnit.MILLISECONDS.convert(val, tu));
        }
    }

    public static class ScaledClock
    extends Clock {
        private final long fStartMs;
        private final double fScale;
        private final long fActualStartMs;

        public ScaledClock() {
            this(ScaledClock.getConfiguredStartTimeMs(), ScaledClock.getConfiguredTimeScale());
        }

        public ScaledClock(long startMs, double scale) {
            this.fStartMs = ScaledClock.makeStartTimeFrom(startMs);
            this.fScale = scale;
            this.fActualStartMs = Clock.now();
            if (this.fScale <= 0.0) {
                throw new IllegalArgumentException("Time scale must be positive.");
            }
        }

        @Override
        public long nowMs() {
            long realNowMs = Clock.now();
            long actualDiffMs = realNowMs - this.fActualStartMs;
            long scaledDiffMs = Math.round((double)actualDiffMs * this.fScale);
            return this.fStartMs + scaledDiffMs;
        }

        public double getScale() {
            return this.fScale;
        }

        private static long makeStartTimeFrom(long timeMs) {
            if (timeMs < 0L) {
                return Math.max(1L, Clock.now() + timeMs);
            }
            return timeMs;
        }

        private static long getConfiguredStartTimeMs() {
            String timeStart = System.getProperty(Clock.skTimeStartMs);
            if (StringUtils.isEmpty(timeStart)) {
                return System.currentTimeMillis();
            }
            try {
                return ScaledClock.makeStartTimeFrom(Long.parseLong(timeStart));
            }
            catch (NumberFormatException x) {
                log.warn("Couldn't parse timeStart: " + x.getMessage());
                return System.currentTimeMillis();
            }
        }

        private static double getConfiguredTimeScale() {
            String timeScale = System.getProperty(Clock.skTimeScaleArg);
            if (StringUtils.isEmpty(timeScale)) {
                return 1.0;
            }
            try {
                double scale = Double.parseDouble(timeScale);
                if (scale > 0.0) {
                    return scale;
                }
                log.warn("Time scale must be a positive number.");
            }
            catch (NumberFormatException x) {
                log.warn("Couldn't parse {} {}, using 1.0", (Object)Clock.skTimeScaleArg, (Object)timeScale);
            }
            return 1.0;
        }
    }
}

