/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jsonpath.spi.mapper;

import io.continual.util.shaded.jsonpath.Configuration;
import io.continual.util.shaded.jsonpath.TypeRef;
import io.continual.util.shaded.jsonpath.spi.mapper.MappingException;
import io.continual.util.shaded.jsonpath.spi.mapper.MappingProvider;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;

public class JakartaMappingProvider
implements MappingProvider {
    private final Jsonb jsonb;
    private Method jsonToClassMethod;
    private Method jsonToTypeMethod;

    public JakartaMappingProvider() {
        this.jsonb = JsonbBuilder.create();
        this.jsonToClassMethod = this.findMethod(this.jsonb.getClass(), "fromJson", JsonParser.class, Class.class);
        this.jsonToTypeMethod = this.findMethod(this.jsonb.getClass(), "fromJson", JsonParser.class, Type.class);
    }

    public JakartaMappingProvider(JsonbConfig jsonbConfiguration) {
        this.jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfiguration);
        this.jsonToClassMethod = this.findMethod(this.jsonb.getClass(), "fromJson", JsonParser.class, Class.class);
        this.jsonToTypeMethod = this.findMethod(this.jsonb.getClass(), "fromJson", JsonParser.class, Type.class);
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        Object result = this.mapImpl(source, targetType);
        return (T)result;
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        Object result = this.mapImpl(source, targetType.getType());
        return (T)result;
    }

    private Object mapImpl(Object source, Type targetType) {
        if (source == null || source == JsonValue.NULL) {
            return null;
        }
        if (source == JsonValue.TRUE) {
            if (Boolean.class.equals((Object)targetType)) {
                return Boolean.TRUE;
            }
            String className = targetType.toString();
            throw new MappingException("JSON boolean (true) cannot be mapped to " + className);
        }
        if (source == JsonValue.FALSE) {
            if (Boolean.class.equals((Object)targetType)) {
                return Boolean.FALSE;
            }
            String className = targetType.toString();
            throw new MappingException("JSON boolean (false) cannot be mapped to " + className);
        }
        if (source instanceof JsonString) {
            if (String.class.equals((Object)targetType)) {
                return ((JsonString)source).getChars();
            }
            String className = targetType.toString();
            throw new MappingException("JSON string cannot be mapped to " + className);
        }
        if (source instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)source;
            if (jsonNumber.isIntegral()) {
                return this.mapIntegralJsonNumber(jsonNumber, this.getRawClass(targetType));
            }
            return this.mapDecimalJsonNumber(jsonNumber, this.getRawClass(targetType));
        }
        if (source instanceof JsonArrayBuilder) {
            source = ((JsonArrayBuilder)source).build();
        } else if (source instanceof JsonObjectBuilder) {
            source = ((JsonObjectBuilder)source).build();
        }
        if (source instanceof Collection) {
            Class<?> rawTargetType = this.getRawClass(targetType);
            Type targetTypeArg = this.getFirstTypeArgument(targetType);
            Collection<Object> result = this.newCollectionOfType(rawTargetType);
            for (Object srcValue : (Collection)source) {
                if (srcValue instanceof JsonObject) {
                    if (targetTypeArg != null) {
                        result.add(this.mapImpl(srcValue, targetTypeArg));
                        continue;
                    }
                    result.add(srcValue);
                    continue;
                }
                result.add(this.unwrapJsonValue(srcValue));
            }
            return result;
        }
        if (source instanceof JsonObject) {
            if (targetType instanceof Class) {
                if (this.jsonToClassMethod != null) {
                    try {
                        JsonStructureToParserAdapter jsonParser = new JsonStructureToParserAdapter((JsonStructure)source);
                        return this.jsonToClassMethod.invoke((Object)this.jsonb, jsonParser, (Class)targetType);
                    }
                    catch (Exception e) {
                        throw new MappingException(e);
                    }
                }
                try {
                    String json = source.toString();
                    return this.jsonb.fromJson(json, (Class)targetType);
                }
                catch (JsonbException e) {
                    throw new MappingException(e);
                }
            }
            if (targetType instanceof ParameterizedType) {
                if (this.jsonToTypeMethod != null) {
                    try {
                        JsonStructureToParserAdapter jsonParser = new JsonStructureToParserAdapter((JsonStructure)source);
                        return this.jsonToTypeMethod.invoke((Object)this.jsonb, jsonParser, targetType);
                    }
                    catch (Exception e) {
                        throw new MappingException(e);
                    }
                }
                try {
                    String json = source.toString();
                    return this.jsonb.fromJson(json, targetType);
                }
                catch (JsonbException e) {
                    throw new MappingException(e);
                }
            }
            throw new MappingException("JSON object cannot be databind to " + targetType);
        }
        return source;
    }

    private <T> T mapIntegralJsonNumber(JsonNumber jsonNumber, Class<?> targetType) {
        if (targetType.isPrimitive()) {
            if (Integer.TYPE.equals(targetType)) {
                return (T)Integer.valueOf(jsonNumber.intValueExact());
            }
            if (Long.TYPE.equals(targetType)) {
                return (T)Long.valueOf(jsonNumber.longValueExact());
            }
        } else {
            if (Integer.class.equals(targetType)) {
                return (T)Integer.valueOf(jsonNumber.intValueExact());
            }
            if (Long.class.equals(targetType)) {
                return (T)Long.valueOf(jsonNumber.longValueExact());
            }
            if (BigInteger.class.equals(targetType)) {
                return (T)jsonNumber.bigIntegerValueExact();
            }
            if (BigDecimal.class.equals(targetType)) {
                return (T)jsonNumber.bigDecimalValue();
            }
        }
        String className = targetType.getSimpleName();
        throw new MappingException("JSON integral number cannot be mapped to " + className);
    }

    private <T> T mapDecimalJsonNumber(JsonNumber jsonNumber, Class<?> targetType) {
        if (targetType.isPrimitive()) {
            if (Float.TYPE.equals(targetType)) {
                return (T)new Float(jsonNumber.doubleValue());
            }
            if (Double.TYPE.equals(targetType)) {
                return (T)Double.valueOf(jsonNumber.doubleValue());
            }
        } else {
            if (Float.class.equals(targetType)) {
                return (T)new Float(jsonNumber.doubleValue());
            }
            if (Double.class.equals(targetType)) {
                return (T)Double.valueOf(jsonNumber.doubleValue());
            }
            if (BigDecimal.class.equals(targetType)) {
                return (T)jsonNumber.bigDecimalValue();
            }
        }
        String className = targetType.getSimpleName();
        throw new MappingException("JSON decimal number cannot be mapped to " + className);
    }

    private Object unwrapJsonValue(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (!(jsonValue instanceof JsonValue)) {
            return jsonValue;
        }
        switch (((JsonValue)jsonValue).getValueType()) {
            case ARRAY: {
                return ((JsonArray)jsonValue).getValuesAs(v -> this.unwrapJsonValue(v));
            }
            case OBJECT: {
                throw new IllegalArgumentException("Use map() method to databind a JsonObject");
            }
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
            case NUMBER: {
                if (((JsonNumber)jsonValue).isIntegral()) {
                    try {
                        return ((JsonNumber)jsonValue).intValueExact();
                    }
                    catch (ArithmeticException e) {
                        return ((JsonNumber)jsonValue).longValueExact();
                    }
                }
                return ((JsonNumber)jsonValue).doubleValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
        }
        return jsonValue;
    }

    private Collection<Object> newCollectionOfType(Class<?> collectionType) throws MappingException {
        if (Collection.class.isAssignableFrom(collectionType)) {
            if (!collectionType.isInterface()) {
                Collection coll = (Collection)this.newNoArgInstance(collectionType);
                return coll;
            }
            if (List.class.isAssignableFrom(collectionType)) {
                return new LinkedList<Object>();
            }
            if (Set.class.isAssignableFrom(collectionType)) {
                return new LinkedHashSet<Object>();
            }
            if (Queue.class.isAssignableFrom(collectionType)) {
                return new LinkedList<Object>();
            }
        }
        String className = collectionType.getSimpleName();
        throw new MappingException("JSON array cannot be mapped to " + className);
    }

    private Object newNoArgInstance(Class<?> targetType) throws MappingException {
        if (targetType.isInterface()) {
            return null;
        }
        for (Constructor<?> ctr : targetType.getConstructors()) {
            if (ctr.getParameterCount() != 0) continue;
            try {
                return ctr.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new MappingException(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String className = targetType.getSimpleName();
        throw new MappingException("Unable to find no-arg ctr for " + className);
    }

    private Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        while (clazz != null && !clazz.isInterface()) {
            for (Method method : clazz.getDeclaredMethods()) {
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods) || Modifier.isAbstract(mods) || !name.equals(method.getName()) || !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private Class<?> getRawClass(Type targetType) {
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        if (targetType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)targetType).getRawType();
        }
        if (targetType instanceof GenericArrayType) {
            String typeName = targetType.getTypeName();
            throw new MappingException("Cannot map JSON element to " + typeName);
        }
        String typeName = targetType.getTypeName();
        throw new IllegalArgumentException("TypeRef not supported: " + typeName);
    }

    private Type getFirstTypeArgument(Type targetType) {
        Type[] args;
        if (targetType instanceof ParameterizedType && (args = ((ParameterizedType)targetType).getActualTypeArguments()) != null && args.length > 0) {
            if (args[0] instanceof Class) {
                return (Class)args[0];
            }
            if (args[0] instanceof ParameterizedType) {
                return (ParameterizedType)args[0];
            }
        }
        return null;
    }

    private static class JsonObjectScope
    extends JsonStructureScope {
        private final Iterator<Map.Entry<String, JsonValue>> it;
        private JsonValue value;
        private String key;

        JsonObjectScope(JsonObject object) {
            this.it = object.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public JsonValue next() {
            Map.Entry<String, JsonValue> next = this.it.next();
            this.key = next.getKey();
            this.value = next.getValue();
            return this.value;
        }

        @Override
        JsonValue getValue() {
            return this.value;
        }

        String getKey() {
            return this.key;
        }
    }

    private static class JsonArrayScope
    extends JsonStructureScope {
        private final Iterator<JsonValue> it;
        private JsonValue value;

        JsonArrayScope(JsonArray array) {
            this.it = array.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public JsonValue next() {
            this.value = this.it.next();
            return this.value;
        }

        @Override
        JsonValue getValue() {
            return this.value;
        }
    }

    private static abstract class JsonStructureScope
    implements Iterator<JsonValue> {
        private JsonStructureScope() {
        }

        abstract JsonValue getValue();
    }

    private static class JsonStructureToParserAdapter
    implements JsonParser {
        private JsonStructureScope scope;
        private JsonParser.Event state;
        private final Deque<JsonStructureScope> ancestry = new ArrayDeque<JsonStructureScope>();

        JsonStructureToParserAdapter(JsonStructure jsonStruct) {
            this.scope = this.createScope((JsonValue)jsonStruct);
        }

        public boolean hasNext() {
            return this.state != JsonParser.Event.END_ARRAY && this.state != JsonParser.Event.END_OBJECT || !this.ancestry.isEmpty();
        }

        public JsonParser.Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.state == null) {
                this.state = this.scope instanceof JsonArrayScope ? JsonParser.Event.START_ARRAY : JsonParser.Event.START_OBJECT;
            } else {
                if (this.state == JsonParser.Event.END_ARRAY || this.state == JsonParser.Event.END_OBJECT) {
                    this.scope = this.ancestry.pop();
                }
                if (this.scope instanceof JsonArrayScope) {
                    if (this.scope.hasNext()) {
                        this.scope.next();
                        this.state = this.getState(this.scope.getValue());
                        if (this.state == JsonParser.Event.START_ARRAY || this.state == JsonParser.Event.START_OBJECT) {
                            this.ancestry.push(this.scope);
                            this.scope = this.createScope(this.scope.getValue());
                        }
                    } else {
                        this.state = JsonParser.Event.END_ARRAY;
                    }
                } else if (this.state == JsonParser.Event.KEY_NAME) {
                    this.state = this.getState(this.scope.getValue());
                    if (this.state == JsonParser.Event.START_ARRAY || this.state == JsonParser.Event.START_OBJECT) {
                        this.ancestry.push(this.scope);
                        this.scope = this.createScope(this.scope.getValue());
                    }
                } else if (this.scope.hasNext()) {
                    this.scope.next();
                    this.state = JsonParser.Event.KEY_NAME;
                } else {
                    this.state = JsonParser.Event.END_OBJECT;
                }
            }
            return this.state;
        }

        public String getString() {
            switch (this.state) {
                case KEY_NAME: {
                    return ((JsonObjectScope)this.scope).getKey();
                }
                case VALUE_STRING: {
                    return ((JsonString)this.scope.getValue()).getString();
                }
                case VALUE_NUMBER: {
                    return ((JsonNumber)this.scope.getValue()).toString();
                }
            }
            throw new IllegalStateException("Parser is not in KEY_NAME, VALUE_STRING, or VALUE_NUMBER state");
        }

        public boolean isIntegralNumber() {
            if (this.state == JsonParser.Event.VALUE_NUMBER) {
                return ((JsonNumber)this.scope.getValue()).isIntegral();
            }
            throw new IllegalStateException("Target json value must a number, not " + this.state);
        }

        public int getInt() {
            if (this.state == JsonParser.Event.VALUE_NUMBER) {
                return ((JsonNumber)this.scope.getValue()).intValue();
            }
            throw new IllegalStateException("Target json value must a number, not " + this.state);
        }

        public long getLong() {
            if (this.state == JsonParser.Event.VALUE_NUMBER) {
                return ((JsonNumber)this.scope.getValue()).longValue();
            }
            throw new IllegalStateException("Target json value must a number, not " + this.state);
        }

        public BigDecimal getBigDecimal() {
            if (this.state == JsonParser.Event.VALUE_NUMBER) {
                return ((JsonNumber)this.scope.getValue()).bigDecimalValue();
            }
            throw new IllegalStateException("Target json value must a number, not " + this.state);
        }

        public JsonLocation getLocation() {
            throw new UnsupportedOperationException("JSON-P adapter does not support getLocation()");
        }

        public void skipArray() {
            if (this.scope instanceof JsonArrayScope) {
                while (this.scope.hasNext()) {
                    this.scope.next();
                }
                this.state = JsonParser.Event.END_ARRAY;
            }
        }

        public void skipObject() {
            if (this.scope instanceof JsonObjectScope) {
                while (this.scope.hasNext()) {
                    this.scope.next();
                }
                this.state = JsonParser.Event.END_OBJECT;
            }
        }

        public void close() {
        }

        private JsonStructureScope createScope(JsonValue value) {
            if (value instanceof JsonArray) {
                return new JsonArrayScope((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return new JsonObjectScope((JsonObject)value);
            }
            throw new JsonException("Cannot create JSON iterator for " + value);
        }

        private JsonParser.Event getState(JsonValue value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    return JsonParser.Event.START_ARRAY;
                }
                case OBJECT: {
                    return JsonParser.Event.START_OBJECT;
                }
                case STRING: {
                    return JsonParser.Event.VALUE_STRING;
                }
                case NUMBER: {
                    return JsonParser.Event.VALUE_NUMBER;
                }
                case TRUE: {
                    return JsonParser.Event.VALUE_TRUE;
                }
                case FALSE: {
                    return JsonParser.Event.VALUE_FALSE;
                }
                case NULL: {
                    return JsonParser.Event.VALUE_NULL;
                }
            }
            throw new JsonException("Unknown value type " + value.getValueType());
        }
    }
}

