/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jsonpath.spi.json;

import io.continual.util.shaded.jsonpath.InvalidJsonException;
import io.continual.util.shaded.jsonpath.JsonPathException;
import io.continual.util.shaded.jsonpath.spi.json.AbstractJsonProvider;
import io.continual.util.shaded.minidev.json.JSONArray;
import io.continual.util.shaded.minidev.json.JSONObject;
import io.continual.util.shaded.minidev.json.JSONStyle;
import io.continual.util.shaded.minidev.json.JSONValue;
import io.continual.util.shaded.minidev.json.parser.JSONParser;
import io.continual.util.shaded.minidev.json.parser.ParseException;
import io.continual.util.shaded.minidev.json.writer.JsonReaderI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private final int parseMode;
    private final JsonReaderI<?> mapper;

    public JsonSmartJsonProvider() {
        this(-1, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int parseMode) {
        this(parseMode, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int parseMode, JsonReaderI<?> mapper) {
        this.parseMode = parseMode;
        this.mapper = mapper;
    }

    @Override
    public Object createArray() {
        return this.mapper.createArray();
    }

    @Override
    public Object createMap() {
        return this.mapper.createObject();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.createParser().parse(json, this.mapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.createParser().parse((Reader)new InputStreamReader(jsonStream, charset), this.mapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)obj, JSONStyle.LT_COMPRESS);
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)obj, JSONStyle.LT_COMPRESS);
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return JSONValue.toJSONString(obj);
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    private JSONParser createParser() {
        return new JSONParser(this.parseMode);
    }
}

