/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jsonpath.internal.path;

import io.continual.util.shaded.jsonpath.Predicate;
import io.continual.util.shaded.jsonpath.internal.function.Parameter;
import io.continual.util.shaded.jsonpath.internal.path.ArrayIndexOperation;
import io.continual.util.shaded.jsonpath.internal.path.ArrayIndexToken;
import io.continual.util.shaded.jsonpath.internal.path.ArraySliceOperation;
import io.continual.util.shaded.jsonpath.internal.path.ArraySliceToken;
import io.continual.util.shaded.jsonpath.internal.path.FunctionPathToken;
import io.continual.util.shaded.jsonpath.internal.path.PathToken;
import io.continual.util.shaded.jsonpath.internal.path.PredicatePathToken;
import io.continual.util.shaded.jsonpath.internal.path.PropertyPathToken;
import io.continual.util.shaded.jsonpath.internal.path.RootPathToken;
import io.continual.util.shaded.jsonpath.internal.path.ScanPathToken;
import io.continual.util.shaded.jsonpath.internal.path.WildcardPathToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PathTokenFactory {
    public static RootPathToken createRootPathToken(char token) {
        return new RootPathToken(token);
    }

    public static PathToken createSinglePropertyPathToken(String property, char stringDelimiter) {
        return new PropertyPathToken(Collections.singletonList(property), stringDelimiter);
    }

    public static PathToken createPropertyPathToken(List<String> properties, char stringDelimiter) {
        return new PropertyPathToken(properties, stringDelimiter);
    }

    public static PathToken createSliceArrayPathToken(ArraySliceOperation arraySliceOperation) {
        return new ArraySliceToken(arraySliceOperation);
    }

    public static PathToken createIndexArrayPathToken(ArrayIndexOperation arrayIndexOperation) {
        return new ArrayIndexToken(arrayIndexOperation);
    }

    public static PathToken createWildCardPathToken() {
        return new WildcardPathToken();
    }

    public static PathToken crateScanToken() {
        return new ScanPathToken();
    }

    public static PathToken createPredicatePathToken(Collection<Predicate> predicates) {
        return new PredicatePathToken(predicates);
    }

    public static PathToken createPredicatePathToken(Predicate predicate) {
        return new PredicatePathToken(predicate);
    }

    public static PathToken createFunctionPathToken(String function, List<Parameter> parameters) {
        return new FunctionPathToken(function, parameters);
    }
}

