/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jsonpath.internal.function.sequence;

import io.continual.util.shaded.jsonpath.JsonPathException;
import io.continual.util.shaded.jsonpath.internal.EvaluationContext;
import io.continual.util.shaded.jsonpath.internal.PathRef;
import io.continual.util.shaded.jsonpath.internal.function.Parameter;
import io.continual.util.shaded.jsonpath.internal.function.PathFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSequenceAggregation
implements PathFunction {
    protected abstract int targetIndex(EvaluationContext var1, List<Parameter> var2);

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            ArrayList objectList = new ArrayList();
            objects.forEach(objectList::add);
            int targetIndex = this.targetIndex(ctx, parameters);
            if (targetIndex >= 0) {
                return objectList.get(targetIndex);
            }
            int realIndex = objectList.size() + targetIndex;
            if (realIndex > 0) {
                return objectList.get(realIndex);
            }
            throw new JsonPathException("Target index:" + targetIndex + " larger than object count:" + objectList.size());
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }

    protected int getIndexFromParameters(EvaluationContext ctx, List<Parameter> parameters) {
        List<Number> numbers = Parameter.toList(Number.class, ctx, parameters);
        return numbers.get(0).intValue();
    }
}

