/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jsonpath.internal;

public class JsonFormatter {
    private static final String INDENT = "   ";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int MODE_SINGLE = 100;
    private static final int MODE_DOUBLE = 101;
    private static final int MODE_ESCAPE_SINGLE = 102;
    private static final int MODE_ESCAPE_DOUBLE = 103;
    private static final int MODE_BETWEEN = 104;

    private static void appendIndent(StringBuilder sb, int count) {
        while (count > 0) {
            sb.append(INDENT);
            --count;
        }
    }

    public static String prettyPrint(String input) {
        input = input.replaceAll("[\\r\\n]", "");
        StringBuilder output = new StringBuilder(input.length() * 2);
        int mode = 104;
        int depth = 0;
        block24: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            block0 : switch (mode) {
                case 104: {
                    switch (ch) {
                        case '[': 
                        case '{': {
                            output.append(ch);
                            output.append(NEW_LINE);
                            JsonFormatter.appendIndent(output, ++depth);
                            continue block24;
                        }
                        case ']': 
                        case '}': {
                            output.append(NEW_LINE);
                            JsonFormatter.appendIndent(output, --depth);
                            output.append(ch);
                            continue block24;
                        }
                        case ',': {
                            output.append(ch);
                            output.append(NEW_LINE);
                            JsonFormatter.appendIndent(output, depth);
                            continue block24;
                        }
                        case ':': {
                            output.append(" : ");
                            continue block24;
                        }
                        case '\'': {
                            output.append(ch);
                            mode = 100;
                            continue block24;
                        }
                        case '\"': {
                            output.append(ch);
                            mode = 101;
                            continue block24;
                        }
                        case ' ': {
                            continue block24;
                        }
                    }
                    output.append(ch);
                    continue block24;
                }
                case 102: {
                    output.append(ch);
                    mode = 100;
                    continue block24;
                }
                case 103: {
                    output.append(ch);
                    mode = 101;
                    continue block24;
                }
                case 100: {
                    output.append(ch);
                    switch (ch) {
                        case '\'': {
                            mode = 104;
                            break;
                        }
                        case '\\': {
                            mode = 102;
                        }
                    }
                    continue block24;
                }
                case 101: {
                    output.append(ch);
                    switch (ch) {
                        case '\"': {
                            mode = 104;
                            break block0;
                        }
                        case '\\': {
                            mode = 103;
                        }
                    }
                }
            }
        }
        return output.toString();
    }
}

