/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jline.console.internal;

import io.continual.util.shaded.jline.console.ConsoleReader;
import io.continual.util.shaded.jline.console.completer.ArgumentCompleter;
import io.continual.util.shaded.jline.console.completer.Completer;
import io.continual.util.shaded.jline.console.history.FileHistory;
import io.continual.util.shaded.jline.console.history.PersistentHistory;
import io.continual.util.shaded.jline.console.internal.ConsoleReaderInputStream;
import io.continual.util.shaded.jline.internal.Configuration;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ConsoleRunner {
    public static final String property = "io.continual.util.shaded.jline.history";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.size() == 0) {
            ConsoleRunner.usage();
            return;
        }
        String historyFileName = System.getProperty(property, null);
        String mainClass = (String)argList.remove(0);
        ConsoleReader reader2 = new ConsoleReader();
        if (historyFileName != null) {
            reader2.setHistory(new FileHistory(new File(Configuration.getUserHome(), String.format(".io.continual.util.shaded.jline-%s.%s.history", mainClass, historyFileName))));
        } else {
            reader2.setHistory(new FileHistory(new File(Configuration.getUserHome(), String.format(".io.continual.util.shaded.jline-%s.history", mainClass))));
        }
        String completors = System.getProperty(ConsoleRunner.class.getName() + ".completers", "");
        ArrayList<Completer> completorList = new ArrayList<Completer>();
        StringTokenizer tok = new StringTokenizer(completors, ",");
        while (tok.hasMoreTokens()) {
            Object obj = Class.forName(tok.nextToken()).newInstance();
            completorList.add((Completer)obj);
        }
        if (completorList.size() > 0) {
            reader2.addCompleter(new ArgumentCompleter(completorList));
        }
        ConsoleReaderInputStream.setIn(reader2);
        try {
            Class<?> type = Class.forName(mainClass);
            Method method = type.getMethod("main", String[].class);
            String[] mainArgs = argList.toArray(new String[argList.size()]);
            method.invoke(null, new Object[]{mainArgs});
        }
        finally {
            ConsoleReaderInputStream.restoreIn();
            if (reader2.getHistory() instanceof PersistentHistory) {
                ((PersistentHistory)reader2.getHistory()).flush();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: \n   java [-Djline.history='name'] " + ConsoleRunner.class.getName() + " <target class name> [args]\n\nThe -Djline.history option will avoid history\nmangling when running ConsoleRunner on the same application.\n\nargs will be passed directly to the target class name.");
    }
}

