/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.shaded.jline.console.history;

import io.continual.util.shaded.jline.console.history.History;
import io.continual.util.shaded.jline.console.history.MemoryHistory;
import io.continual.util.shaded.jline.console.history.PersistentHistory;
import io.continual.util.shaded.jline.internal.Log;
import io.continual.util.shaded.jline.internal.Preconditions;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;

public class FileHistory
extends MemoryHistory
implements PersistentHistory,
Flushable {
    private final File file;

    public FileHistory(File file) throws IOException {
        this(file, true);
    }

    public FileHistory(File file, boolean doInit) throws IOException {
        this.file = Preconditions.checkNotNull(file).getAbsoluteFile();
        if (doInit) {
            this.load();
        }
    }

    public void load() throws IOException {
        this.load(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void load(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (file.exists()) {
            Log.trace("Loading history from: ", file);
            FileReader reader2 = null;
            try {
                reader2 = new FileReader(file);
                this.load(reader2);
            }
            finally {
                if (reader2 != null) {
                    reader2.close();
                }
            }
        }
    }

    public void load(InputStream input) throws IOException {
        Preconditions.checkNotNull(input);
        this.load(new InputStreamReader(input));
    }

    public void load(Reader reader2) throws IOException {
        String item;
        Preconditions.checkNotNull(reader2);
        BufferedReader input = new BufferedReader(reader2);
        while ((item = input.readLine()) != null) {
            this.internalAdd(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Log.trace("Flushing history");
        if (!this.file.exists()) {
            File dir = this.file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                Log.warn("Failed to create directory: ", dir);
            }
            if (!this.file.createNewFile()) {
                Log.warn("Failed to create file: ", this.file);
            }
        }
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        try {
            for (History.Entry entry2 : this) {
                out.println(entry2.value());
            }
        }
        finally {
            out.close();
        }
    }

    public void purge() throws IOException {
        Log.trace("Purging history");
        this.clear();
        if (!this.file.delete()) {
            Log.warn("Failed to delete history file: ", this.file);
        }
    }
}

