/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class nvJsonObject
implements NvWriteable,
JsonSerialized {
    private final JSONObject fObject;
    private TreeSet<String> fKeyCache = null;

    public nvJsonObject() {
        this.fObject = new JSONObject();
    }

    public nvJsonObject(JSONObject o) {
        this.fObject = o;
    }

    @Override
    public JSONObject toJson() {
        return JsonUtil.clone(this.fObject);
    }

    public String toString() {
        return this.fObject.toString();
    }

    @Override
    public String get(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key) throws NvReadable.MissingReqdSettingException {
        String result = this.getString(key, null);
        if (result == null) {
            throw new NvReadable.MissingReqdSettingException(key);
        }
        return result;
    }

    @Override
    public String getString(String key, String defValue) {
        try {
            Object o = JsonEval.eval(this.fObject, key);
            if (o != null) {
                return o.toString();
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return defValue;
    }

    @Override
    public char getCharacter(String key) throws NvReadable.MissingReqdSettingException {
        try {
            String s = this.getString(key);
            if (s.length() == 1) {
                return s.charAt(0);
            }
            throw new NvReadable.MissingReqdSettingException(key);
        }
        catch (JSONException e) {
            throw new NvReadable.MissingReqdSettingException(key);
        }
    }

    @Override
    public char getCharacter(String key, char defValue) {
        try {
            return this.getCharacter(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
    }

    @Override
    public boolean getBoolean(String key) throws NvReadable.MissingReqdSettingException {
        return this.getGenericValue(key, Boolean.FALSE);
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        return this.optGenericValue(key, defValue);
    }

    @Override
    public int getInt(String key) throws NvReadable.MissingReqdSettingException {
        return this.getGenericValue(key, 0);
    }

    @Override
    public int getInt(String key, int defValue) {
        return this.optGenericValue(key, defValue);
    }

    @Override
    public long getLong(String key) throws NvReadable.MissingReqdSettingException {
        return this.getGenericValue(key, 0L);
    }

    @Override
    public long getLong(String key, long defValue) {
        return this.optGenericValue(key, defValue);
    }

    @Override
    public double getDouble(String key) throws NvReadable.MissingReqdSettingException {
        return this.getGenericValue(key, 0.0);
    }

    @Override
    public double getDouble(String key, double defValue) {
        return this.optGenericValue(key, defValue);
    }

    @Override
    public byte[] getBytes(String key) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException {
        return TypeConvertor.hexStringToBytes(this.getString(key));
    }

    @Override
    public byte[] getBytes(String key, byte[] defValue) {
        try {
            return this.getBytes(key);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defValue;
        }
        catch (NvReadable.InvalidSettingValueException e) {
            return defValue;
        }
    }

    @Override
    public String[] getStrings(String key) throws NvReadable.MissingReqdSettingException {
        JSONArray val = this.getGenericValue(key, new JSONArray());
        return JsonVisitor.arrayToList(val).toArray(new String[val.length()]);
    }

    @Override
    public String[] getStrings(String key, String[] defValue) {
        try {
            return this.getStrings(key);
        }
        catch (NvReadable.MissingReqdSettingException x) {
            return defValue;
        }
    }

    @Override
    public int size() {
        return this.getAllKeys().size();
    }

    @Override
    public boolean hasValueFor(String key) {
        return this.getAllKeys().contains(key);
    }

    @Override
    public synchronized Collection<String> getAllKeys() {
        if (this.fKeyCache == null) {
            this.fKeyCache = new TreeSet();
            this.getKeys(this.fKeyCache, "", this.fObject);
        }
        return this.fKeyCache;
    }

    @Override
    public Map<String, String> getCopyAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.copyInto(result);
        return result;
    }

    @Override
    public void copyInto(NvWriteable writeable) {
        for (String key : this.getAllKeys()) {
            try {
                Object o = JsonEval.eval(this.fObject, key);
                if (o instanceof Integer) {
                    writeable.set(key, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    writeable.set(key, (Long)o);
                    continue;
                }
                if (o instanceof Double) {
                    writeable.set(key, (Double)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    writeable.set(key, (Boolean)o);
                    continue;
                }
                if (o instanceof JSONArray) {
                    writeable.set(key, this.getStrings(key));
                    continue;
                }
                writeable.set(key, (String)o);
            }
            catch (JSONException e) {
                throw new RuntimeException("error copying value for " + key, e);
            }
            catch (NvReadable.MissingReqdSettingException e) {
                throw new RuntimeException("error copying value for " + key, e);
            }
        }
    }

    @Override
    public void copyInto(Map<String, String> writeable) {
        for (String key : this.getAllKeys()) {
            try {
                writeable.put(key, JsonEval.eval(this.fObject, key).toString());
            }
            catch (JSONException e) {
                throw new RuntimeException("error copying value for " + key, e);
            }
        }
    }

    @Override
    public void rescan() {
    }

    @Override
    public void clear() {
        for (String key : this.getAllKeys()) {
            this.fObject.remove(key);
        }
    }

    @Override
    public synchronized void set(String key, String value) {
        this.fObject.put(key, (Object)value);
    }

    @Override
    public void set(String key, char value) {
        this.fObject.put(key, (Object)("" + value));
    }

    @Override
    public synchronized void set(String key, int value) {
        this.fObject.put(key, value);
    }

    @Override
    public synchronized void set(String key, long value) {
        this.fObject.put(key, value);
    }

    @Override
    public synchronized void set(String key, double value) {
        this.fObject.put(key, value);
    }

    @Override
    public synchronized void set(String key, boolean value) {
        this.fObject.put(key, value);
    }

    @Override
    public synchronized void set(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.fObject.put(e.getKey(), (Object)e.getValue());
        }
    }

    @Override
    public synchronized void unset(String key) {
        this.fObject.remove(key);
    }

    @Override
    public synchronized void set(String key, byte[] value) {
        this.set(key, value, 0, value.length);
    }

    @Override
    public synchronized void set(String key, byte[] value, int offset, int length) {
        this.set(key, TypeConvertor.bytesToHex(value, offset, length));
    }

    @Override
    public void set(String key, String[] values) {
        JSONArray a = new JSONArray();
        for (String s : values) {
            a.put((Object)s);
        }
        this.fObject.put(key, (Object)a);
    }

    public void set(String key, List<String> values) {
        JSONArray a = new JSONArray();
        for (String s : values) {
            a.put((Object)s);
        }
        this.fObject.put(key, (Object)a);
    }

    private void getKeys(Set<String> set, String prefix, JSONObject top) {
        Set thisObj = top.keySet();
        for (Object subKeyObj : thisObj) {
            String subKey = subKeyObj.toString();
            String topLevelKey = prefix.length() == 0 ? subKey : prefix + "." + subKey;
            set.add(topLevelKey);
            Object subObj = top.get(subKey);
            if (!(subObj instanceof JSONObject)) continue;
            this.getKeys(set, topLevelKey, (JSONObject)subObj);
        }
    }

    private <T> T getGenericValue(String key, T sampleValue) throws NvReadable.MissingReqdSettingException {
        try {
            Object o = JsonEval.eval(this.fObject, key);
            if (o != null && sampleValue.getClass().isAssignableFrom(o.getClass())) {
                return (T)o;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new NvReadable.MissingReqdSettingException(key);
    }

    private <T> T optGenericValue(String key, T defVal) {
        try {
            return this.getGenericValue(key, defVal);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            return defVal;
        }
    }
}

