/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv;

import io.continual.util.nv.NvWriteable;
import java.util.Collection;
import java.util.Map;

public interface NvReadable {
    public String get(String var1);

    public String getString(String var1) throws MissingReqdSettingException;

    public String getString(String var1, String var2);

    public char getCharacter(String var1) throws MissingReqdSettingException;

    public char getCharacter(String var1, char var2);

    public boolean getBoolean(String var1) throws MissingReqdSettingException;

    public boolean getBoolean(String var1, boolean var2);

    public int getInt(String var1) throws MissingReqdSettingException;

    public int getInt(String var1, int var2);

    public long getLong(String var1) throws MissingReqdSettingException;

    public long getLong(String var1, long var2);

    public double getDouble(String var1) throws MissingReqdSettingException;

    public double getDouble(String var1, double var2);

    public byte[] getBytes(String var1) throws MissingReqdSettingException, InvalidSettingValueException;

    public byte[] getBytes(String var1, byte[] var2);

    public String[] getStrings(String var1) throws MissingReqdSettingException;

    public String[] getStrings(String var1, String[] var2);

    public int size();

    public boolean hasValueFor(String var1);

    public Collection<String> getAllKeys();

    public Map<String, String> getCopyAsMap();

    public void copyInto(NvWriteable var1);

    public void copyInto(Map<String, String> var1);

    public void rescan() throws LoadException;

    public static class InvalidSettingValueException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final String fKey;

        public InvalidSettingValueException(String key) {
            super("Invalid setting for \"" + key + "\"");
            this.fKey = key;
        }

        public InvalidSettingValueException(String key, Throwable cause) {
            super("Invalid setting for \"" + key + "\" because " + cause.getMessage(), cause);
            this.fKey = key;
        }

        public InvalidSettingValueException(String key, String why) {
            super("Invalid setting for \"" + key + "\" because " + why);
            this.fKey = key;
        }

        public InvalidSettingValueException(String key, Throwable cause, String why) {
            super("Invalid setting for \"" + key + "\" because " + why, cause);
            this.fKey = key;
        }
    }

    public static class MissingReqdSettingException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final String fKey;

        public MissingReqdSettingException(String key) {
            super("Missing required setting \"" + key + "\"");
            this.fKey = key;
        }

        public MissingReqdSettingException(String key, Throwable cause) {
            super("Missing required setting \"" + key + "\" because " + cause.getMessage(), cause);
            this.fKey = key;
        }
    }

    public static class LoadException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoadException(String reason) {
            super(reason);
        }

        public LoadException(Throwable cause) {
            super(cause);
        }
    }
}

