/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.db.file;

import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.db.file.BlockFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonObjectFile
implements Closeable {
    private final BlockFile fFile;

    public static void initialize(File file, int blockSize) throws IOException {
        BlockFile.initialize(file, blockSize);
    }

    public JsonObjectFile(File f) throws IOException {
        this(f, true);
    }

    public JsonObjectFile(File f, boolean withWrite) throws IOException {
        this(f, withWrite, null);
    }

    public JsonObjectFile(File f, boolean withWrite, String passwd) throws IOException {
        this.fFile = new BlockFile(f, withWrite, passwd);
    }

    public String getFilePath() {
        return this.fFile.getFilePath();
    }

    @Override
    public void close() throws IOException {
        this.fFile.close();
    }

    public JSONObject read(long address) throws IOException {
        JSONObject o = null;
        try (InputStream is = this.fFile.readToStream(address);){
            o = new JSONObject((JSONTokener)new CommentedJsonTokener(new InputStreamReader(is)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return o;
    }

    public long write(JSONObject o) throws IOException {
        byte[] b = o.toString().getBytes(Charset.forName("UTF-8"));
        return this.fFile.create(b);
    }

    public void overwrite(long address, JSONObject o) throws IOException {
        byte[] b = o.toString().getBytes(Charset.forName("UTF-8"));
        this.fFile.overwrite(address, b);
    }

    public void delete(long address) throws IOException {
        this.fFile.delete(address);
    }

    public long indexToAddress(long index) {
        return this.fFile.indexToAddress(index);
    }
}

