/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import io.continual.util.shaded.jsonpath.Configuration;
import io.continual.util.shaded.jsonpath.JsonPath;
import io.continual.util.shaded.jsonpath.Option;
import io.continual.util.shaded.jsonpath.Predicate;
import io.continual.util.shaded.jsonpath.spi.json.JsonProvider;
import io.continual.util.shaded.jsonpath.spi.json.JsonSmartJsonProvider;
import io.continual.util.shaded.jsonpath.spi.mapper.JsonSmartMappingProvider;
import io.continual.util.shaded.jsonpath.spi.mapper.MappingProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class JsonPathEval {
    private JsonPathEval() {
    }

    public static List<String> evaluateJsonPath(JSONObject root, String jsonPath) {
        return (List)JsonPath.parse(root.toString()).read(jsonPath, new Predicate[0]);
    }

    static {
        Configuration.setDefaults(new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JsonSmartJsonProvider();
            private final MappingProvider mappingProvider = new JsonSmartMappingProvider();

            @Override
            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            @Override
            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            @Override
            public Set<Option> options() {
                return EnumSet.of(Option.ALWAYS_RETURN_LIST);
            }
        });
    }
}

