/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.csv;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CsvEncoder {
    public static final char kDefaultQuoteChar = '\"';
    public static final char kDefaultFieldSeparatorChar = ',';
    private static final TimeZone UtcTz = TimeZone.getTimeZone("UTC");
    private static final String kGoofyExcelCsvDate = "MM/dd/yy HH:mm:ss";
    private static final String kIso8601Date = "yyyy-MM-dd'T'HH:mm'Z'";

    private CsvEncoder() {
    }

    public static String encodeForCsv(String val) {
        return CsvEncoder.encodeForCsv(val, false);
    }

    public static String encodeForCsv(String val, boolean forceQuotes) {
        return CsvEncoder.encodeForCsv(val, '\"', ',', forceQuotes);
    }

    public static String encodeForCsv(String val, char quoteChar, char sepChar) {
        return CsvEncoder.encodeForCsv(val, quoteChar, sepChar, true);
    }

    public static String encodeForCsv(String val, char quoteChar, char sepChar, boolean forceQuotes) {
        Object result = "";
        if (val != null) {
            if (val.length() == 0) {
                result = "" + quoteChar + quoteChar;
            } else {
                boolean needWrap = forceQuotes || val.indexOf(quoteChar) != -1 || val.indexOf(sepChar) != -1 || val.contains("\r") || val.contains("\n");
                result = CsvEncoder.escapeString(val, quoteChar, sepChar, needWrap);
            }
        }
        return result;
    }

    public static String encodeForCsv(Date value) {
        return CsvEncoder.encodeForCsv(value, UtcTz, true);
    }

    public static String encodeForCsv(Date value, TimeZone intoTz, boolean excelCompatible) {
        SimpleDateFormat df = new SimpleDateFormat(excelCompatible ? kGoofyExcelCsvDate : kIso8601Date);
        df.setTimeZone(intoTz);
        return df.format(value);
    }

    private static String escapeString(String val, char quoteChar, char sepChar, boolean needWrap) {
        StringBuffer result = new StringBuffer();
        if (needWrap) {
            result.append(quoteChar);
        }
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c == quoteChar) {
                result.append(c);
            }
            result.append(c);
        }
        if (needWrap) {
            result.append(quoteChar);
        }
        return result.toString();
    }
}

