/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CsvCallbackReader<E extends Exception> {
    public static final String kLineField = "line";
    public static final String kLineField_Default = "line";
    public static final String kHasHeaderRow = "header";
    public static final String kDelimiter = "delimiter";
    public static final String kQuote = "quote";
    public static final String kPassThru = "passthru";
    private int fLineCount;
    private final char fDelimiter;
    private final char fQuote;
    private String[] fColumns;
    private boolean fHasHeaderRow;
    String fLastToken;
    boolean fLastOnLine;

    public CsvCallbackReader(boolean header) {
        this('\"', ',', header);
    }

    public CsvCallbackReader(char quoteChar, char fieldSepChar, boolean header) {
        this.fDelimiter = fieldSepChar;
        this.fQuote = quoteChar;
        this.fColumns = null;
        this.fHasHeaderRow = header;
        this.fLineCount = 0;
    }

    public void reset() {
        this.fLineCount = 0;
    }

    public void read(InputStream is, RecordHandler<E> rh) throws IOException, E {
        if (is == null) {
            throw new IOException("No CSV stream provided");
        }
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        this.read(isr, rh);
    }

    public void read(InputStreamReader isr, RecordHandler<E> rh) throws IOException, E {
        boolean keepGoing = true;
        HashMap<String, String> s = this.readNextLine(isr);
        while (s != null && keepGoing) {
            keepGoing = rh.handler(s);
            if (!keepGoing) continue;
            s = this.readNextLine(isr);
        }
        if (s == null) {
            isr.close();
        }
    }

    public List<String> getColumnNames() {
        LinkedList<String> result = new LinkedList<String>();
        if (this.fColumns != null) {
            for (String c : this.fColumns) {
                result.add(c);
            }
        }
        return result;
    }

    public int getLinesParsed() {
        return this.fLineCount;
    }

    public boolean hasHeader() {
        return this.fHasHeaderRow;
    }

    protected void readTerm(InputStreamReader is) throws IOException {
        boolean quoted;
        this.fLastOnLine = false;
        this.fLastToken = null;
        StringBuffer sb = new StringBuffer();
        int current = is.read();
        if (current < 0 || CsvCallbackReader.isLineEnding(current)) {
            this.fLastOnLine = true;
            return;
        }
        if (current == this.fDelimiter) {
            this.fLastOnLine = false;
            this.fLastToken = "";
            return;
        }
        boolean bl = quoted = current == this.fQuote;
        if (!quoted) {
            sb.append((char)current);
        }
        boolean terminated = false;
        boolean lastWasQuote = false;
        while (!terminated) {
            current = is.read();
            if (current < 0) {
                this.fLastToken = sb.toString();
                this.fLastOnLine = true;
                return;
            }
            if (current == this.fQuote) {
                if (quoted) {
                    if (lastWasQuote) {
                        sb.append((char)current);
                        lastWasQuote = false;
                        continue;
                    }
                    lastWasQuote = true;
                    continue;
                }
                sb.append((char)current);
                continue;
            }
            if (current == this.fDelimiter || CsvCallbackReader.isLineEnding(current)) {
                if (quoted) {
                    if (lastWasQuote) {
                        terminated = true;
                        this.fLastOnLine = CsvCallbackReader.isLineEnding(current);
                        continue;
                    }
                    sb.append((char)current);
                    continue;
                }
                terminated = true;
                this.fLastOnLine = CsvCallbackReader.isLineEnding(current);
                continue;
            }
            sb.append((char)current);
        }
        this.fLastToken = sb.toString();
    }

    private static boolean isLineEnding(int c) {
        return c == 10;
    }

    private List<String> readLineValues(InputStreamReader is, boolean withTrim) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        do {
            this.readTerm(is);
            if (this.fLastToken == null) continue;
            result.add(withTrim ? this.fLastToken.trim() : this.fLastToken);
        } while (!this.fLastOnLine);
        return result;
    }

    private HashMap<String, String> readNextLine(InputStreamReader is) throws IOException {
        if (this.fHasHeaderRow && this.fLineCount == 0) {
            this.parseHeader(is);
        }
        return this.parseLine(is);
    }

    private void parseHeader(InputStreamReader is) throws IOException {
        List<String> headers = this.readLineValues(is, true);
        while (headers.size() == 0 || headers.iterator().next().startsWith("#")) {
            headers = this.readLineValues(is, true);
        }
        this.fColumns = headers.toArray(new String[headers.size()]);
    }

    private HashMap<String, String> parseLine(InputStreamReader is) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        int colNum = 0;
        if (this.fColumns != null) {
            for (String col : this.fColumns) {
                result.put(col, "");
            }
        }
        boolean didOne = false;
        do {
            this.readTerm(is);
            if (this.fLastToken == null) continue;
            didOne = true;
            String name = this.fColumns != null && colNum < this.fColumns.length ? this.fColumns[colNum] : "" + colNum;
            ++colNum;
            result.put(name, this.fLastToken);
        } while (!this.fLastOnLine);
        if (didOne) {
            ++this.fLineCount;
        }
        return didOne ? result : null;
    }

    public static interface RecordHandler<E extends Exception> {
        public boolean handler(Map<String, String> var1) throws E;
    }
}

