/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.SpecialFnsDataSource;
import io.continual.util.nv.NvReadable;
import java.util.LinkedList;
import java.util.List;

public class StringUtils {
    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isEmpty(String s) {
        return !StringUtils.isNotEmpty(s);
    }

    public static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public static String substringTo(String s, char delim) {
        int found = s.indexOf(delim);
        return found > -1 ? s.substring(0, found) : s;
    }

    public static int isOneOf(char c, char[] set) {
        int result = -1;
        for (result = 0; result < set.length && c != set[result]; ++result) {
        }
        return result >= set.length ? -1 : result;
    }

    public static int indexOfAnyOf(String s, char[] chars) {
        return StringUtils.indexOfAnyOf(s, chars, 0);
    }

    public static int indexOfAnyOf(String s, char[] chars, int fromIndex) {
        int result = -1;
        for (int i = fromIndex; i < s.length() && result == -1; ++i) {
            int one = StringUtils.isOneOf(s.charAt(i), chars);
            if (-1 == one) continue;
            result = i;
        }
        return result;
    }

    public static String toFirstUpperRestLower(String s) {
        return StringUtils.toFirstUpper(s == null ? null : s.toLowerCase());
    }

    public static String toFirstUpper(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toUpperCase(s.charAt(0)));
        if (len > 1) {
            sb.append(s.substring(1));
        }
        return sb.toString();
    }

    public static String dequote(String s) {
        return StringUtils.dequote(s, new char[]{'\"', '\''});
    }

    public static String dequote(String s, char[] quoteChars) {
        String result = s;
        if (StringUtils.indexOfAnyOf(s, quoteChars) == 0) {
            char leading = s.charAt(0);
            if (s.charAt(s.length() - 1) == leading) {
                result = s.substring(1, s.length() - 1);
            }
        }
        return result;
    }

    public static String[] splitList(String s) {
        List<String> resultList = StringUtils.splitListToList(s);
        return resultList.toArray(new String[resultList.size()]);
    }

    public static String[] splitList(String s, char[] separators, char[] quoteChars) {
        List<String> resultList = StringUtils.splitListToList(s, separators, quoteChars);
        return resultList.toArray(new String[resultList.size()]);
    }

    public static List<String> splitListToList(String s) {
        return StringUtils.splitListToList(s, new char[]{',', ';'}, new char[]{'\'', '\"'});
    }

    public static List<String> splitListToList(String s, char[] separators, char[] quoteChars) {
        LinkedList<String> resultList = new LinkedList<String>();
        String remains = s;
        while (remains.length() > 0) {
            valueInfo vi = StringUtils.getLeadingValue(remains, quoteChars, separators);
            if (vi == null) continue;
            if (vi.fValue == null) {
                vi = new valueInfo("", vi.fNextFieldAt);
            }
            resultList.add(vi.fValue.trim());
            if (vi.fNextFieldAt > -1) {
                remains = remains.substring(vi.fNextFieldAt).trim();
                continue;
            }
            remains = "";
        }
        return resultList;
    }

    public static valueInfo getLeadingValue(String from) {
        return StringUtils.getLeadingValue(from, '\"', ',');
    }

    public static valueInfo getLeadingValue(String from, char quoteChar, char delimChar) {
        return StringUtils.getLeadingValue(from, new char[]{quoteChar}, new char[]{delimChar});
    }

    public static valueInfo getLeadingValue(String from, char[] quoteChars, char[] delimChars) {
        valueInfo vi = new valueInfo();
        if (from.length() > 0) {
            boolean quoted;
            char current = from.charAt(0);
            int quoteId = StringUtils.isOneOf(current, quoteChars);
            boolean bl = quoted = quoteId != -1;
            if (quoted) {
                int quote;
                char quoteChar = quoteChars[quoteId];
                int foundEnd = -1;
                int quoteScanFrom = 1;
                while (-1 == foundEnd && (quote = from.indexOf(quoteChar, quoteScanFrom)) != -1) {
                    if (quote + 1 < from.length() && from.charAt(quote + 1) == quoteChar) {
                        quoteScanFrom = quote + 2;
                        continue;
                    }
                    foundEnd = quote;
                }
                if (foundEnd > -1) {
                    StringBuffer fixedUp = new StringBuffer();
                    String val = from.substring(1, foundEnd);
                    boolean lastWasQuote = false;
                    for (int i = 0; i < val.length(); ++i) {
                        char c = val.charAt(i);
                        if (c == quoteChar) {
                            if (!lastWasQuote) {
                                fixedUp.append(c);
                            }
                            lastWasQuote = !lastWasQuote;
                            continue;
                        }
                        fixedUp.append(c);
                        lastWasQuote = false;
                    }
                    int nextFieldAt = StringUtils.indexOfAnyOf(from, delimChars, foundEnd + 1);
                    vi = new valueInfo(fixedUp.toString(), nextFieldAt != -1 ? nextFieldAt + 1 : nextFieldAt);
                }
            } else {
                int delim = StringUtils.indexOfAnyOf(from, delimChars);
                vi = delim == -1 ? new valueInfo(from, -1) : (delim == 0 ? new valueInfo(null, 1) : new valueInfo(from.substring(0, delim), delim + 1));
            }
        }
        return vi;
    }

    public static List<fieldInfo> split(String from, char quoteChar, char delimChar) {
        LinkedList<fieldInfo> result = new LinkedList<fieldInfo>();
        String remains = from;
        int pos = 0;
        while (remains.length() > 0) {
            valueInfo vi = StringUtils.getLeadingValue(remains, quoteChar, delimChar);
            fieldInfo fi = new fieldInfo(vi.fValue, pos);
            result.add(fi);
            if (vi.fNextFieldAt > -1) {
                pos += vi.fNextFieldAt;
                remains = remains.substring(vi.fNextFieldAt);
                continue;
            }
            remains = "";
        }
        return result;
    }

    public static int indexOf(String s, charSelector cc) {
        int len = s.length();
        for (int current = 0; current < len; ++current) {
            Character currChar = Character.valueOf(s.charAt(current));
            if (!cc.select(currChar)) continue;
            return current;
        }
        return -1;
    }

    public static String evaluate(final NvReadable data2, String val) {
        return ExpressionEvaluator.evaluateText(val, new ExprDataSource(){

            @Override
            public Object eval(String label) {
                return data2.getString(label, null);
            }
        }, new EnvDataSource(), new SpecialFnsDataSource());
    }

    public static String limitLengthTo(String s, int maxlen) {
        int len = s.length();
        if (len > maxlen) {
            return s.substring(0, maxlen);
        }
        return s;
    }

    public static String appendIfMissing(String base, String ending) {
        return base.endsWith(ending) ? base : base + ending;
    }

    private StringUtils() {
    }

    public static class valueInfo {
        public final String fValue;
        public final int fNextFieldAt;

        public valueInfo() {
            this(null, -1);
        }

        public valueInfo(String val, int next) {
            this.fValue = val;
            this.fNextFieldAt = next;
        }
    }

    public static class fieldInfo {
        public final String fValue;
        public final int fStartsAt;

        public fieldInfo(String val, int startPos) {
            this.fValue = val;
            this.fStartsAt = startPos;
        }

        public String toString() {
            return this.fValue + " [" + this.fStartsAt + "]";
        }
    }

    public static interface charSelector {
        public boolean select(Character var1);
    }
}

