/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.TypeConvertor;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha256HmacSigner {
    private static final String kHmacSha256Algo = "HmacSHA256";

    private Sha256HmacSigner() {
    }

    public static String sign(String message, String key) {
        try {
            byte[] rawHmac = Sha256HmacSigner.signToBytes(message, key);
            return TypeConvertor.base64Encode(rawHmac, Integer.MAX_VALUE);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] signToBytes(String message, String key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), kHmacSha256Algo);
            Mac mac = Mac.getInstance(kHmacSha256Algo);
            mac.init(secretKey);
            return mac.doFinal(message.getBytes());
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }
}

