/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.TypeConvertor;
import io.continual.util.time.Clock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class HumanReadableHelper {
    private static final long kMultiplier = 1000L;
    private static final long kKilobyte = 1000L;
    private static final long kMegabyte = 1000000L;
    private static final long kGigabyte = 1000000000L;
    private static final long kTerabyte = 1000000000000L;
    private static final long kPetabyte = 1000000000000000L;
    private static final long kExabyte = 1000000000000000000L;
    public static final long kMillisecond = 1L;
    public static final long kSecond = 1000L;
    public static final long kMinute = 60000L;
    public static final long kHour = 3600000L;
    public static final long kDay = 86400000L;
    public static final long kWeek = 604800000L;
    public static final long kMonth = 2592000000L;
    public static final long kYear = 31536000000L;
    private static String[] kDateFormats = new String[]{"yyyy-MM-dd", "MM/dd/yyyy"};
    private static final long kMsThreshold = System.currentTimeMillis() / 100L;
    private static long[] kTimeVals = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L, 1000L, 1L};
    private static String[] kTimeValAbbvsSingle = new String[]{"yr", "month", "wk", "day", "hr", "m", "s", "ms"};
    private static String[] kTimeValAbbvsPlural = new String[]{"yrs", "months", "wks", "days", "hrs", "m", "s", "ms"};

    private HumanReadableHelper() {
    }

    public static String byteCountValue(long inBytes) {
        String result = inBytes + " bytes";
        if (inBytes > 1000000000000000000L) {
            double d = inBytes / 1000000000000000000L;
            result = d + " EB";
        } else if (inBytes > 1000000000000000L) {
            double d = inBytes / 1000000000000000L;
            result = d + " PB";
        } else if (inBytes > 1000000000000L) {
            double d = inBytes / 1000000000000L;
            result = d + " TB";
        } else if (inBytes > 1000000000L) {
            double d = inBytes / 1000000000L;
            result = d + " GB";
        } else if (inBytes > 1000000L) {
            double d = inBytes / 1000000L;
            result = d + " MB";
        } else if (inBytes > 1000L) {
            double d = inBytes / 1000L;
            result = d + " kB";
        }
        return result;
    }

    @Deprecated
    public static String memoryValue(long inBytes) {
        return HumanReadableHelper.byteCountValue(inBytes);
    }

    public static List<String> hexDumpLine(byte[] bytes, int offset, int length) {
        return HumanReadableHelper.hexDumpLine(bytes, offset, length, 16);
    }

    public static List<String> hexDumpLine(byte[] bytes, int offset, int length, int lineLengthInBytes) {
        LinkedList<String> result = new LinkedList<String>();
        while (offset < length) {
            int bytesRemaining = length - offset;
            int bytesThisLine = offset + Math.min(bytesRemaining, lineLengthInBytes);
            StringBuilder hexPart = new StringBuilder();
            StringBuilder asciiPart = new StringBuilder();
            while (offset < bytesThisLine) {
                byte ch = bytes[offset];
                String byteInHex = TypeConvertor.byteToHex((int)ch);
                int byteAsChar = HumanReadableHelper.isPrintableForHexDump(ch) ? (int)ch : 46;
                hexPart.append(byteInHex).append(' ');
                asciiPart.append((char)byteAsChar);
                ++offset;
            }
            StringBuilder line = new StringBuilder().append(hexPart.toString());
            while (line.length() < lineLengthInBytes * 3 + 4) {
                line.append(' ');
            }
            line.append(asciiPart.toString());
            result.add(line.toString());
        }
        return result;
    }

    private static boolean isPrintableForHexDump(int ch) {
        return ch >= 32 && ch <= 126;
    }

    private static String buildCents(long v) {
        if (v < 10L) {
            return "0" + v;
        }
        String s = "" + v;
        while (s.length() < 2) {
            s = s + "0";
        }
        return s;
    }

    public static String dollarValue(double d) {
        long cents;
        boolean negate;
        boolean bl = negate = d < 0.0;
        if (negate) {
            d *= -1.0;
        }
        long dollars = Math.round(Math.floor(d));
        for (cents = Math.round((d - (double)dollars) * 100.0); cents > 99L; cents -= 100L) {
            ++dollars;
        }
        return (negate ? "-" : "") + HumanReadableHelper.numberValue(dollars) + "." + HumanReadableHelper.buildCents(cents);
    }

    public static String roundedDollarValue(double d) {
        return HumanReadableHelper.numberValue(Math.round(d));
    }

    public static String numberValue(long units) {
        StringBuffer sb = new StringBuffer();
        String raw = "" + units;
        int count = raw.length();
        int firstPart = count % 3;
        int printed = 3 - firstPart;
        for (int i = 0; i < count; ++i) {
            if (printed == 3) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                printed = 0;
            }
            sb.append(raw.charAt(i));
            ++printed;
        }
        return sb.toString();
    }

    public static String ratioValue(double d) {
        double rounded2 = (double)Math.round(d * 100.0) / 100.0;
        return "" + rounded2;
    }

    public static String pctValue(double d) {
        long pct = Math.round(d * 100.0);
        return pct + "%";
    }

    public static String dateValue(Date d) {
        return HumanReadableHelper.dateValue(d, TimeZone.getTimeZone("UTC"));
    }

    public static String dateValue(Date d, TimeZone tz) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
        sdf.setTimeZone(tz);
        return sdf.format(d);
    }

    public static String elapsedTimeSince(Date d) {
        if (d == null) {
            return "";
        }
        return HumanReadableHelper.elapsedTimeSince(d.getTime());
    }

    public static String elapsedTimeSince(long epochMs) {
        return HumanReadableHelper.elapsedTimeSince(epochMs, 1L, 2);
    }

    public static String elapsedTimeSince(Date d, long smallestUnitInMillis) {
        if (d == null) {
            return "";
        }
        return HumanReadableHelper.elapsedTimeSince(d.getTime(), smallestUnitInMillis);
    }

    public static String elapsedTimeSince(long epochMs, long smallestUnitInMillis) {
        return HumanReadableHelper.elapsedTimeSince(epochMs, smallestUnitInMillis, -1);
    }

    public static String elapsedTimeSince(Date epochMs, long smallestUnitInMillis, int maxLevels) {
        return HumanReadableHelper.elapsedTimeSince(epochMs.getTime(), smallestUnitInMillis, maxLevels);
    }

    public static String elapsedTimeSince(long epochMs, long smallestUnitInMillis, int maxLevels) {
        return HumanReadableHelper.elapsedTimeBetween(Clock.now(), epochMs, smallestUnitInMillis, maxLevels);
    }

    public static String elapsedTimeBetween(long startMs, long endMs) {
        return HumanReadableHelper.elapsedTimeBetween(startMs, endMs, 1L, 2);
    }

    public static String elapsedTimeBetween(long startMs, long endMs, long smallestUnitInMillis, int maxLevels) {
        long elapsedMs = startMs - endMs;
        if (elapsedMs < 0L) {
            String amt = HumanReadableHelper.timeValue(elapsedMs * -1L, TimeUnit.MILLISECONDS, smallestUnitInMillis, maxLevels);
            if (amt == null || amt.length() == 0) {
                return "just now";
            }
            return amt + " in the future";
        }
        String amt = HumanReadableHelper.timeValue(elapsedMs, TimeUnit.MILLISECONDS, smallestUnitInMillis, maxLevels);
        if (amt == null || amt.length() == 0) {
            return "just now";
        }
        return amt + " ago";
    }

    public static String timeValue(long units, TimeUnit tu, long smallestUnit) {
        return HumanReadableHelper.timeValue(units, tu, smallestUnit, -1);
    }

    public static String timeValue(long units, TimeUnit tu, long smallestUnit, int maxLevels) {
        return HumanReadableHelper.timeValue(new TimeValueContext(units, tu, smallestUnit, maxLevels));
    }

    public static long parseDuration(String duration) {
        if (duration == null) {
            return 0L;
        }
        if (duration.endsWith("d") || duration.endsWith("days")) {
            String valueStr = duration.substring(0, duration.indexOf("d"));
            double value = Double.parseDouble(valueStr);
            double asMs = value * 8.64E7;
            return Math.round(asMs);
        }
        if (duration.endsWith("h") || duration.endsWith("hr") || duration.endsWith("hrs")) {
            String valueStr = duration.substring(0, duration.indexOf("h"));
            double value = Double.parseDouble(valueStr);
            double asMs = value * 3600000.0;
            return Math.round(asMs);
        }
        if (duration.endsWith("m") || duration.endsWith("min") || duration.endsWith("mins")) {
            String valueStr = duration.substring(0, duration.indexOf("m"));
            double value = Double.parseDouble(valueStr);
            double asMs = value * 60000.0;
            return Math.round(asMs);
        }
        if (duration.endsWith("s") || duration.endsWith("sec") || duration.endsWith("secs")) {
            String valueStr = duration.substring(0, duration.indexOf("s"));
            double value = Double.parseDouble(valueStr);
            double asMs = value * 1000.0;
            return Math.round(asMs);
        }
        if (duration.endsWith("ms") || duration.endsWith("msec") || duration.endsWith("millis")) {
            String valueStr = duration.substring(0, duration.indexOf("m"));
            double value = Double.parseDouble(valueStr);
            return Math.round(value);
        }
        if (duration.endsWith("us") || duration.endsWith("\u03bcs") || duration.endsWith("micros")) {
            int pos = Integer.MAX_VALUE;
            for (String suffix : new String[]{"u", "\u03bc", "m"}) {
                int spos = duration.indexOf(suffix);
                if (spos < 0 || spos >= pos) continue;
                pos = spos;
            }
            String valueStr = duration.substring(0, pos);
            double value = Double.parseDouble(valueStr);
            return Math.round(value / 1000.0);
        }
        double value = Double.parseDouble(duration);
        return Math.round(value);
    }

    public static Date parseTypicalDates(String d) throws ParseException {
        return HumanReadableHelper.parseTypicalDates(d, TimeZone.getTimeZone("UTC"));
    }

    public static Date parseTypicalDates(String d, TimeZone tz) throws ParseException {
        if (d.equalsIgnoreCase("today") || d.equalsIgnoreCase("now")) {
            return new Date();
        }
        try {
            long number = Long.parseLong(d);
            if (number > kMsThreshold) {
                return new Date(number);
            }
            return new Date(number * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            for (String sdfFmt : kDateFormats) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(sdfFmt);
                    sdf.setTimeZone(tz);
                    return sdf.parse(d);
                }
                catch (ParseException parseException) {
                }
            }
            throw new ParseException("Unrecognized date [" + d + "].", 0);
        }
    }

    private static String timeValue(TimeValueContext tvc) {
        StringBuffer result = new StringBuffer();
        int firstUnitIndex = -1;
        for (int unit = 0; unit < kTimeVals.length && kTimeVals[unit] >= tvc.fSmallestUnit && (tvc.fMaxLevels <= -1 || firstUnitIndex <= -1 || unit < firstUnitIndex + tvc.fMaxLevels); ++unit) {
            if (tvc.fRemainingMs < kTimeVals[unit]) continue;
            long count = tvc.fRemainingMs / kTimeVals[unit];
            tvc.fRemainingMs -= count * kTimeVals[unit];
            if (firstUnitIndex >= 0) {
                result.append(", ");
            }
            result.append(count).append(" ").append(count == 1L ? kTimeValAbbvsSingle[unit] : kTimeValAbbvsPlural[unit]);
            if (firstUnitIndex >= 0) continue;
            firstUnitIndex = unit;
        }
        return result.toString();
    }

    public static String listOfItems(List<String> items, String separator, String finalConjunction) {
        int size = items.size();
        if (size < 1) {
            return "";
        }
        switch (size) {
            case 1: {
                return items.iterator().next();
            }
            case 2: {
                return items.get(0) + " " + finalConjunction + " " + items.get(1);
            }
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            result.append(items.get(i));
            result.append(separator);
        }
        result.append(finalConjunction);
        result.append(" ");
        result.append(items.get(size - 1));
        return result.toString();
    }

    private static class TimeValueContext {
        public final long fTimeValueMs;
        public long fRemainingMs;
        public long fSmallestUnit;
        public int fMaxLevels;

        public TimeValueContext(long units, TimeUnit tu, long smallestUnit, int maxLevels) {
            this.fRemainingMs = this.fTimeValueMs = TimeUnit.MILLISECONDS.convert(units, tu);
            this.fSmallestUnit = smallestUnit;
            this.fMaxLevels = maxLevels;
        }
    }
}

