/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console.shell;

import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.shell.Command;
import io.continual.util.console.shell.CommandList;
import io.continual.util.console.shell.ConsoleLooper;
import io.continual.util.console.shell.SimpleCommand;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class StdCommandList
implements CommandList {
    private final HashMap<String, Command> fCommands = new HashMap();

    public StdCommandList() {
        this(true);
    }

    public StdCommandList(boolean withStdCommands) {
        if (withStdCommands) {
            this.addStandardCommands();
        }
    }

    public void registerCommand(Command c) {
        this.fCommands.put(c.getCommand(), c);
    }

    public void removeCommand(String key) {
        this.fCommands.remove(key);
    }

    public void clearCommands() {
        this.fCommands.clear();
    }

    public void addStandardCommands() {
        this.registerCommand(new SimpleCommand("exit"){

            @Override
            public ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs prefs, PrintStream outTo) {
                return ConsoleLooper.InputResult.kQuit;
            }
        });
        this.registerCommand(new SimpleCommand("quit"){

            @Override
            public ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs prefs, PrintStream outTo) {
                return ConsoleLooper.InputResult.kQuit;
            }
        });
        this.registerCommand(new SimpleCommand("help", "help [<command>]"){

            @Override
            protected void setupParser(CmdLineParser clp) {
                clp.requireFileArguments(0, 1);
            }

            @Override
            public ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs prefs, PrintStream outTo) {
                if (prefs.getFileArguments().size() == 1) {
                    String cmdText = prefs.getFileArguments().firstElement();
                    Command cmd = StdCommandList.this.fCommands.get(cmdText);
                    if (cmd != null) {
                        outTo.println("    " + cmd.getUsage());
                        String help = cmd.getHelp();
                        if (help != null) {
                            outTo.println();
                            outTo.println(help);
                        }
                    } else {
                        outTo.println("Unknown command: " + cmdText + ".");
                    }
                } else {
                    outTo.println("The available commands are:");
                    outTo.println();
                    LinkedList<String> commands = new LinkedList<String>();
                    commands.addAll(StdCommandList.this.getAllCommands());
                    Collections.sort(commands);
                    for (String cmd : commands) {
                        outTo.println("    " + cmd);
                    }
                    outTo.println();
                    outTo.println("You can type 'help <command>' to get more info on that command.");
                }
                return ConsoleLooper.InputResult.kReady;
            }
        });
    }

    public Collection<String> getAllCommands() {
        return this.fCommands.keySet();
    }

    @Override
    public Command getCommandFor(String cmd) {
        return this.fCommands.get(cmd);
    }
}

