/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console.shell;

import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.shell.Command;
import io.continual.util.console.shell.ConsoleLooper;
import io.continual.util.nv.NvReadable;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public abstract class SimpleCommand
implements Command {
    private final String fCmd;
    private final String fUsage;
    private final String fHelp;
    private final CmdLineParser fArgsParser;
    private CmdLinePrefs fPrefs;
    private boolean fEnabled;

    protected SimpleCommand(String cmd) {
        this(cmd, cmd, null);
    }

    protected SimpleCommand(String cmd, String usage) {
        this(cmd, usage, null);
    }

    protected SimpleCommand(String cmd, String usage, String help) {
        this.fCmd = cmd;
        this.fUsage = usage;
        this.fHelp = help;
        this.fArgsParser = new CmdLineParser();
        this.fPrefs = null;
        this.fEnabled = true;
    }

    public void enable(boolean e) {
        this.fEnabled = e;
    }

    public boolean enabled() {
        return this.fEnabled;
    }

    @Override
    public final void checkArgs(NvReadable basePrefs, String[] args) throws ConsoleProgram.UsageException {
        this.setupParser(this.fArgsParser);
        this.fPrefs = this.fArgsParser.processArgs(args);
    }

    @Override
    public String getCommand() {
        return this.fCmd;
    }

    @Override
    public String getUsage() {
        return this.fUsage;
    }

    @Override
    public String getHelp() {
        return this.fHelp;
    }

    public static <T> T getWorkspaceObject(Map<String, Object> map, String key, Class<T> clazz) {
        Object val = map.get(key);
        if (clazz.isInstance(val)) {
            return (T)val;
        }
        return null;
    }

    @Override
    public final ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, PrintStream outTo) throws ConsoleProgram.UsageException {
        try {
            return this.execute(workspace, this.fPrefs, outTo);
        }
        catch (NvReadable.MissingReqdSettingException e) {
            throw new ConsoleProgram.UsageException(e);
        }
    }

    protected abstract ConsoleLooper.InputResult execute(HashMap<String, Object> var1, CmdLinePrefs var2, PrintStream var3) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException;

    protected void setupParser(CmdLineParser clp) {
    }
}

