/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console;

import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import io.continual.util.nv.impl.nvEnvProperties;
import io.continual.util.nv.impl.nvInstallTypeWrapper;
import io.continual.util.nv.impl.nvReadableStack;
import io.continual.util.nv.impl.nvWriteableTable;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleProgram {
    private final CmdLineParser fCmdLineParser;
    private final nvWriteableTable fDefaults;
    private final nvWriteableTable fHostInfo = new nvWriteableTable();
    private static final Logger log = LoggerFactory.getLogger(ConsoleProgram.class);

    protected CmdLineParser getCmdLineParser() {
        return this.fCmdLineParser;
    }

    protected ConsoleProgram() {
        this.fDefaults = new nvWriteableTable();
        this.fCmdLineParser = new CmdLineParser();
    }

    public void runFromMain(String[] args) throws UsageException, NvReadable.LoadException, NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, StartupFailureException {
        Looper l;
        this.installShutdownHook();
        this.setupHostInfo();
        this.setupDefaults(this.fDefaults);
        this.setupOptions(this.fCmdLineParser);
        CmdLinePrefs cmdLine = this.fCmdLineParser.processArgs(args);
        nvReadableStack stack = new nvReadableStack();
        stack.push(this.fHostInfo);
        stack.push(new nvEnvProperties());
        stack.push(this.fDefaults);
        stack.push(cmdLine);
        nvInstallTypeWrapper wrapper = new nvInstallTypeWrapper(stack);
        NvReadable config = this.loadAdditionalConfig(wrapper);
        if (config != null) {
            stack.pushBelow(config, cmdLine);
            wrapper.rescan();
        }
        if ((l = this.init(wrapper, cmdLine)) != null && l.setup(wrapper, cmdLine)) {
            while (l.loop(wrapper)) {
            }
            l.teardown(wrapper);
        }
        this.cleanup();
    }

    protected void onShutdown() {
    }

    protected ConsoleProgram setupDefaults(NvWriteable pt) {
        return this;
    }

    protected ConsoleProgram setupOptions(CmdLineParser p) {
        return this;
    }

    protected NvReadable loadAdditionalConfig(NvReadable currentPrefs) throws NvReadable.LoadException, NvReadable.MissingReqdSettingException {
        return null;
    }

    protected Looper init(NvReadable p, CmdLinePrefs cmdLine) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, StartupFailureException {
        return null;
    }

    protected void cleanup() {
    }

    protected List<File> expandFileArg(String arg) {
        String matchPart;
        Pattern p;
        File[] files;
        LinkedList<File> fileList = new LinkedList<File>();
        File file = new File(arg);
        File parentDir = file.getParentFile();
        if (parentDir != null && (files = parentDir.listFiles(new FilenameFilter(){
            final /* synthetic */ Pattern val$p;
            {
                this.val$p = pattern;
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.val$p.matcher(name).matches();
            }
        })) != null) {
            for (File f : files) {
                fileList.add(f);
            }
        }
        return fileList;
    }

    private void setupHostInfo() {
        try {
            this.fHostInfo.set("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            log.warn("Couldn't establish hostname.", (Throwable)e);
        }
    }

    private void installShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ConsoleProgram.this.onShutdown();
            }
        });
    }

    public static interface Looper {
        public boolean setup(NvReadable var1, CmdLinePrefs var2);

        public boolean loop(NvReadable var1);

        public void teardown(NvReadable var1);
    }

    public static class StartupFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public StartupFailureException(Exception x) {
            super(x);
        }

        public StartupFailureException(String msg) {
            super(msg);
        }

        public StartupFailureException(String msg, Exception x) {
            super(msg, x);
        }
    }

    public static class UsageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UsageException(String correctUsage) {
            super(correctUsage);
        }

        public UsageException(Exception cause) {
            super(cause);
        }
    }
}

