/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MultiMap<K extends Comparable<? super K>, V> {
    private final Hashtable<K, List<V>> fMultiMap = new Hashtable();

    public MultiMap() {
    }

    public MultiMap(Map<K, V> data2) {
        this();
        for (Map.Entry<K, V> e : data2.entrySet()) {
            this.put((Comparable)e.getKey(), e.getValue());
        }
    }

    public MultiMap<K, V> clone() {
        MultiMap<Comparable, V> newMap = new MultiMap<Comparable, V>();
        for (Map.Entry<K, List<V>> e : this.fMultiMap.entrySet()) {
            Comparable key = (Comparable)e.getKey();
            newMap.put(key, (Collection<V>)this.get(key));
        }
        return newMap;
    }

    public String toString() {
        return this.fMultiMap.toString();
    }

    public synchronized void put(K k) {
        this.getOrCreateFor(k);
    }

    public synchronized void put(K k, V v) {
        LinkedList<V> list = new LinkedList<V>();
        list.add(v);
        this.put(k, (Collection<V>)list);
    }

    public synchronized void put(K k, Collection<V> v) {
        List<V> itemList = this.getOrCreateFor(k);
        itemList.removeAll(v);
        itemList.addAll(v);
    }

    public synchronized void putAll(Map<K, ? extends Collection<V>> values) {
        for (Map.Entry<K, Collection<V>> e : values.entrySet()) {
            this.put((K)((Comparable)e.getKey()), e.getValue());
        }
    }

    public synchronized boolean containsKey(K k) {
        return this.fMultiMap.containsKey(k);
    }

    public synchronized List<V> get(K k) {
        List<Object> itemList = new LinkedList();
        if (this.fMultiMap.containsKey(k)) {
            itemList = this.getOrCreateFor(k);
        }
        return new LinkedList(itemList);
    }

    public V getFirst(K k) {
        List<V> items = this.get(k);
        if (items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public synchronized Collection<K> getKeys() {
        return this.fMultiMap.keySet();
    }

    public synchronized Set<K> keySet() {
        return new TreeSet<K>(this.getKeys());
    }

    public synchronized Map<K, List<V>> getValues() {
        return this.fMultiMap;
    }

    public synchronized Set<Map.Entry<K, List<V>>> entrySet() {
        TreeSet<Map.Entry<K, List<V>>> result = new TreeSet<Map.Entry<K, List<V>>>(new EntryComparator());
        for (final Map.Entry<K, List<V>> e : this.fMultiMap.entrySet()) {
            result.add(new Map.Entry<K, List<V>>(){

                @Override
                public K getKey() {
                    return (Comparable)e.getKey();
                }

                @Override
                public List<V> getValue() {
                    return (List)e.getValue();
                }

                @Override
                public List<V> setValue(List<V> value) {
                    return (List)e.getValue();
                }
            });
        }
        return result;
    }

    public synchronized Map<K, Collection<V>> getCopyAsSimpleMap() {
        HashMap result = new HashMap();
        for (Map.Entry<K, List<V>> e : this.fMultiMap.entrySet()) {
            LinkedList list = new LinkedList();
            list.addAll(e.getValue());
            result.put((Comparable)e.getKey(), list);
        }
        return result;
    }

    public synchronized List<V> remove(K k) {
        return this.fMultiMap.remove(k);
    }

    public synchronized void remove(K k, V v) {
        List<V> itemList = this.getOrCreateFor(k);
        itemList.remove(v);
    }

    public synchronized void clear() {
        this.fMultiMap.clear();
    }

    public synchronized int size() {
        return this.fMultiMap.size();
    }

    public synchronized int size(K k) {
        return this.getOrCreateFor(k).size();
    }

    private synchronized List<V> getOrCreateFor(K k) {
        List<V> itemList = this.fMultiMap.get(k);
        if (itemList == null) {
            itemList = new LinkedList<V>();
            this.fMultiMap.put(k, itemList);
        }
        return itemList;
    }

    private static class EntryComparator<K extends Comparable<? super K>, V>
    implements Comparator<Map.Entry<K, List<V>>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<K, List<V>> o1, Map.Entry<K, List<V>> o2) {
            int keyComp = ((Comparable)o1.getKey()).compareTo(o2.getKey());
            if (keyComp != 0) {
                return keyComp;
            }
            List<V> list1 = o1.getValue();
            List<V> list2 = o2.getValue();
            int sizeComp = Integer.compare(list1.size(), list2.size());
            if (sizeComp != 0) {
                return sizeComp;
            }
            for (int i = 0; i < list1.size(); ++i) {
                int cmp;
                V v1 = list1.get(i);
                V v2 = list2.get(i);
                if (v1 == null && v2 != null) {
                    return -1;
                }
                if (v1 != null && v2 == null) {
                    return 1;
                }
                if (v1 == null && v2 == null) continue;
                String v1Str = v1.toString();
                String v2Str = v2.toString();
                if (v1Str == null && v2Str != null) {
                    return -1;
                }
                if (v1Str != null && v2Str == null) {
                    return 1;
                }
                if (v1Str == null && v2Str == null || (cmp = v1Str.compareTo(v2Str)) == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

