/*
 * Decompiled with CFR 0.152.
 */
package io.continual.notify;

import io.continual.util.time.Clock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.json.JSONObject;

public interface ContinualAlertTracker {
    default public Alert onset(String subject, String condition) {
        return this.onset(subject, condition, Clock.now());
    }

    default public Alert onset(String subject, String condition, Throwable x) {
        JSONObject addlData = new JSONObject();
        ContinualAlertTracker.populateExceptionInto(addlData, x);
        return this.onset(subject, condition, Clock.now(), addlData);
    }

    default public Alert onset(String subject, String condition, long atMs) {
        return this.onset(subject, condition, atMs, new JSONObject());
    }

    default public Alert onset(String subject, String condition, JSONObject addlData) {
        return this.onset(subject, condition, Clock.now(), addlData);
    }

    public static void populateExceptionInto(JSONObject addlData, Throwable t) {
        Object stack = "??";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(baos);){
            t.printStackTrace(ps);
            ps.close();
            stack = baos.toString();
        }
        catch (IOException x) {
            stack = "?? IOException: " + x.getMessage();
        }
        addlData.put("class", (Object)t.getClass().getName()).put("message", (Object)t.getMessage()).put("stack", stack);
    }

    public Alert onset(String var1, String var2, long var3, JSONObject var5);

    public Alert get(String var1, String var2);

    public Alert clear(String var1, String var2);

    public Collection<Alert> standingAlerts();

    public static interface Alert {
        public String subject();

        public String condition();

        public long when();

        default public void clear() {
            this.clear(Clock.now());
        }

        public void clear(long var1);
    }
}

