/*
 * Decompiled with CFR 0.152.
 */
package io.continual.notify;

import io.continual.notify.ContinualAlertTracker;
import io.continual.notify.ContinualNotifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinualAlertAgent
implements ContinualAlertTracker {
    private final HashMap<String, HashMap<String, ContinualAlertTracker.Alert>> fAlertsBySubjectAndCondition = new HashMap();
    private final ContinualNotifier fEventsOut;
    private static final Logger log = LoggerFactory.getLogger(ContinualAlertAgent.class);

    public ContinualAlertAgent() {
        this(new ContinualNotifier());
    }

    public ContinualAlertAgent(ContinualNotifier out) {
        this.fEventsOut = out;
    }

    @Override
    public ContinualAlertTracker.Alert onset(String subject, String condition, long atMs, JSONObject addlData) {
        HashMap byCondition = this.fAlertsBySubjectAndCondition.computeIfAbsent(subject, k -> new HashMap());
        ContinualAlertTracker.Alert alert = (ContinualAlertTracker.Alert)byCondition.get(condition);
        if (alert != null) {
            log.info("Alert for {}:{} already exists; ignored.", (Object)subject, (Object)condition);
        } else {
            alert = new IntAlert(subject, condition, atMs, addlData);
            this.fEventsOut.onSubject(alert.subject()).withCondition(alert.condition()).withAddlData("at", atMs).withAddlData("addl", addlData).asOnset().send();
            byCondition.put(condition, alert);
            log.info("Raised alert: {}", (Object)alert);
        }
        return alert;
    }

    @Override
    public ContinualAlertTracker.Alert get(String subject, String condition) {
        HashMap<String, ContinualAlertTracker.Alert> byCondition = this.fAlertsBySubjectAndCondition.get(subject);
        if (byCondition == null) {
            return null;
        }
        return byCondition.get(condition);
    }

    @Override
    public ContinualAlertTracker.Alert clear(String subject, String condition) {
        ContinualAlertTracker.Alert a = this.get(subject, condition);
        if (a != null) {
            a.clear();
        }
        return a;
    }

    @Override
    public Collection<ContinualAlertTracker.Alert> standingAlerts() {
        LinkedList<ContinualAlertTracker.Alert> result = new LinkedList<ContinualAlertTracker.Alert>();
        for (Map.Entry<String, HashMap<String, ContinualAlertTracker.Alert>> e : this.fAlertsBySubjectAndCondition.entrySet()) {
            result.addAll(e.getValue().values());
        }
        return result;
    }

    private class IntAlert
    implements ContinualAlertTracker.Alert {
        private final String fSubject;
        private final String fCondition;
        private final long fWhen;
        private final JSONObject fAddlData;

        public IntAlert(String subj, String cond, long when, JSONObject addlData) {
            this.fSubject = subj;
            this.fCondition = cond;
            this.fWhen = when;
            this.fAddlData = addlData == null ? new JSONObject() : addlData;
        }

        public String toString() {
            return new JSONObject().put("subject", (Object)this.subject()).put("condition", (Object)this.condition()).put("when", this.when()).put("addldata", (Object)this.fAddlData).toString();
        }

        @Override
        public String subject() {
            return this.fSubject;
        }

        @Override
        public String condition() {
            return this.fCondition;
        }

        @Override
        public long when() {
            return this.fWhen;
        }

        @Override
        public void clear(long clearTimeMs) {
            HashMap<String, ContinualAlertTracker.Alert> byCondition = ContinualAlertAgent.this.fAlertsBySubjectAndCondition.get(this.subject());
            ContinualAlertTracker.Alert fromMap = byCondition.remove(this.condition());
            if (fromMap != this) {
                log.warn("Lookup for clear of {} found a different instance.", (Object)this);
            } else {
                ContinualAlertAgent.this.fEventsOut.onSubject(this.subject()).withCondition(this.condition()).withAddlData("at", clearTimeMs).asClear().send();
                log.info("Cleared alert: {}", (Object)this);
            }
        }
    }
}

