/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.client.impl.recovery;

import io.continual.shaded.com.rabbitmq.client.AMQP;
import io.continual.shaded.com.rabbitmq.client.ShutdownSignalException;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.DefaultRetryHandler;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedBinding;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedEntity;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedQueue;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.RetryContext;
import io.continual.shaded.com.rabbitmq.client.impl.recovery.TopologyRecoveryRetryHandlerBuilder;
import io.continual.shaded.com.rabbitmq.utility.Utility;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiPredicate;

public abstract class TopologyRecoveryRetryLogic {
    public static final BiPredicate<RecordedEntity, Exception> CHANNEL_CLOSED_NOT_FOUND = (entity, ex) -> {
        ShutdownSignalException cause;
        if (ex.getCause() instanceof ShutdownSignalException && (cause = (ShutdownSignalException)ex.getCause()).getReason() instanceof AMQP.Channel.Close) {
            return ((AMQP.Channel.Close)cause.getReason()).getReplyCode() == 404;
        }
        return false;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CHANNEL = context -> {
        if (!context.entity().getChannel().isOpen()) {
            context.connection().recoverChannel(context.entity().getChannel());
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_QUEUE = context -> {
        if (context.entity() instanceof RecordedQueue) {
            RecordedQueue recordedQueue = context.queue();
            AutorecoveringConnection connection = context.connection();
            connection.recoverQueue(recordedQueue.getName(), recordedQueue);
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING_QUEUE = context -> {
        if (context.entity() instanceof RecordedQueueBinding) {
            RecordedBinding binding = context.binding();
            AutorecoveringConnection connection = context.connection();
            RecordedQueue recordedQueue = connection.getRecordedQueues().get(binding.getDestination());
            if (recordedQueue != null) {
                connection.recoverQueue(recordedQueue.getName(), recordedQueue);
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING = context -> {
        context.binding().recover();
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_PREVIOUS_QUEUE_BINDINGS = context -> {
        if (context.entity() instanceof RecordedQueueBinding) {
            String queue = context.binding().getDestination();
            for (RecordedBinding recordedBinding : Utility.copy(context.connection().getRecordedBindings())) {
                if (recordedBinding == context.entity()) break;
                if (!(recordedBinding instanceof RecordedQueueBinding) || !queue.equals(recordedBinding.getDestination())) continue;
                recordedBinding.recover();
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE = context -> {
        if (context.entity() instanceof RecordedConsumer) {
            RecordedConsumer consumer = context.consumer();
            AutorecoveringConnection connection = context.connection();
            RecordedQueue recordedQueue = connection.getRecordedQueues().get(consumer.getQueue());
            if (recordedQueue != null) {
                connection.recoverQueue(recordedQueue.getName(), recordedQueue);
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE_BINDINGS = context -> {
        if (context.entity() instanceof RecordedConsumer) {
            String queue = context.consumer().getQueue();
            for (RecordedBinding recordedBinding : Utility.copy(context.connection().getRecordedBindings())) {
                if (!(recordedBinding instanceof RecordedQueueBinding) || !queue.equals(recordedBinding.getDestination())) continue;
                recordedBinding.recover();
            }
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<String> RECOVER_CONSUMER = context -> context.consumer().recover();
    public static final DefaultRetryHandler.RetryOperation<String> RECOVER_PREVIOUS_CONSUMERS = context -> {
        if (context.entity() instanceof RecordedConsumer) {
            AutorecoveringChannel channel = context.consumer().getChannel();
            for (RecordedConsumer consumer : Utility.copy(context.connection().getRecordedConsumers()).values()) {
                if (consumer == context.entity()) break;
                if (consumer.getChannel() != channel) continue;
                RetryContext retryContext = new RetryContext(consumer, context.exception(), context.connection());
                RECOVER_CONSUMER_QUEUE.call(retryContext);
                context.connection().recoverConsumer(consumer.getConsumerTag(), consumer);
                RECOVER_CONSUMER_QUEUE_BINDINGS.call(retryContext);
            }
            return context.consumer().getConsumerTag();
        }
        return null;
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_PREVIOUS_AUTO_DELETE_QUEUES = context -> {
        block4: {
            block3: {
                if (!(context.entity() instanceof RecordedQueue)) break block3;
                AutorecoveringConnection connection = context.connection();
                RecordedQueue queue = context.queue();
                for (Map.Entry<String, RecordedQueue> entry : Utility.copy(connection.getRecordedQueues()).entrySet()) {
                    if (entry.getValue() == queue) break;
                    if (queue.getChannel() != entry.getValue().getChannel() || !entry.getValue().isAutoDelete() && !entry.getValue().isExclusive()) continue;
                    connection.recoverQueue(entry.getKey(), entry.getValue());
                }
                break block4;
            }
            if (!(context.entity() instanceof RecordedQueueBinding)) break block4;
            AutorecoveringConnection connection = context.connection();
            LinkedHashSet<String> queues = new LinkedHashSet<String>();
            for (Map.Entry<String, RecordedQueue> entry : Utility.copy(connection.getRecordedQueues()).entrySet()) {
                if (context.entity().getChannel() != entry.getValue().getChannel() || !entry.getValue().isAutoDelete() && !entry.getValue().isExclusive()) continue;
                connection.recoverQueue(entry.getKey(), entry.getValue());
                queues.add(entry.getValue().getName());
            }
            for (RecordedBinding binding : Utility.copy(connection.getRecordedBindings())) {
                if (!(binding instanceof RecordedQueueBinding) || !queues.contains(binding.getDestination())) continue;
                binding.recover();
            }
        }
        return null;
    };
    public static final TopologyRecoveryRetryHandlerBuilder RETRY_ON_QUEUE_NOT_FOUND_RETRY_HANDLER = TopologyRecoveryRetryHandlerBuilder.builder().queueRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).bindingRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).consumerRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).queueRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_QUEUE).andThen(RECOVER_PREVIOUS_AUTO_DELETE_QUEUES)).bindingRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_BINDING_QUEUE).andThen(RECOVER_BINDING).andThen(RECOVER_PREVIOUS_QUEUE_BINDINGS).andThen(RECOVER_PREVIOUS_AUTO_DELETE_QUEUES)).consumerRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_CONSUMER_QUEUE).andThen(RECOVER_CONSUMER).andThen(RECOVER_CONSUMER_QUEUE_BINDINGS).andThen(RECOVER_PREVIOUS_CONSUMERS));
}

