/*
 * Decompiled with CFR 0.152.
 */
package io.continual.metrics.reporters;

import io.continual.builder.Builder;
import io.continual.metrics.DropWizardMetricsService;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReporter
extends SimpleService {
    private final DropWizardMetricsService fMetrics;
    private final AtomicBoolean fRunFlag;
    private final MetricsDumpThread fMetricsDumper;
    private static final Logger log = LoggerFactory.getLogger(LoggingReporter.class);

    public LoggingReporter(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fMetrics = (DropWizardMetricsService)((Object)sc.get("metrics", DropWizardMetricsService.class));
        if (this.fMetrics == null) {
            throw new Builder.BuildFailure("No metrics catalog in metrics LoggingReporter.");
        }
        this.fRunFlag = new AtomicBoolean(true);
        this.fMetricsDumper = new MetricsDumpThread(config.optLong("periodMs", 15000L));
    }

    protected void onStartRequested() throws Service.FailedToStart {
        this.fMetricsDumper.start();
    }

    protected void onStopRequested() {
        this.fRunFlag.set(false);
    }

    private class MetricsDumpThread
    extends Thread {
        private final long fPeriodMs;

        public MetricsDumpThread(long periodMs) {
            super("processor metrics dumper");
            this.setDaemon(true);
            this.fPeriodMs = periodMs;
        }

        @Override
        public void run() {
            try {
                while (LoggingReporter.this.fRunFlag.get()) {
                    Thread.sleep(this.fPeriodMs);
                    log.info(LoggingReporter.this.fMetrics.toJson().toString());
                }
                log.info("Metrics dump thread exiting.");
            }
            catch (InterruptedException e) {
                log.warn("Metrics dumper interrupted: ", e);
            }
            catch (Throwable e) {
                log.warn("Metrics dumper terminated: ", e);
            }
        }
    }
}

