/*
 * Decompiled with CFR 0.152.
 */
package io.continual.messaging;

import io.continual.messaging.ContinualMessage;
import io.continual.messaging.ContinualMessageStream;
import io.continual.messaging.MessagePublishException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public interface ContinualMessageSink {
    public static final String kGeneralMessageStreamName = ".";
    public static final ContinualMessageStream kGeneralMsgStream = ContinualMessageStream.fromName(".");

    default public void send(ContinualMessage msg) throws MessagePublishException {
        this.send(kGeneralMsgStream, msg);
    }

    default public void send(ContinualMessage ... msgs) throws MessagePublishException {
        this.send(kGeneralMsgStream, msgs);
    }

    default public void send(Collection<ContinualMessage> msgs) throws MessagePublishException {
        this.send(kGeneralMsgStream, msgs);
    }

    default public void send(ContinualMessageStream stream, ContinualMessage message) throws MessagePublishException {
        this.send(stream, Collections.singletonList(message));
    }

    default public void send(ContinualMessageStream stream, ContinualMessage message, AckType acks) throws MessagePublishException {
        this.send(stream, Collections.singletonList(message), acks);
    }

    default public void send(ContinualMessageStream stream, ContinualMessage ... msgs) throws MessagePublishException {
        this.send(stream, Arrays.asList(msgs));
    }

    default public void send(ContinualMessageStream stream, Collection<ContinualMessage> msgs) throws MessagePublishException {
        this.send(stream, msgs, AckType.MINIMAL);
    }

    public void send(ContinualMessageStream var1, Collection<ContinualMessage> var2, AckType var3) throws MessagePublishException;

    public static enum AckType {
        NONE,
        MINIMAL,
        ALL;


        public static AckType fromUserValue(String text) {
            String v = text.trim().toUpperCase();
            if (v.equals("MIN") || v.equals("MINIMAL")) {
                return MINIMAL;
            }
            if (v.equals("NONE")) {
                return NONE;
            }
            if (v.equals("ALL")) {
                return ALL;
            }
            throw new IllegalArgumentException("Unknown ack type: " + text);
        }
    }
}

