/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.remote;

import io.continual.builder.Builder;
import io.continual.iam.IamDb;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.Resource;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamGroupDoesNotExist;
import io.continual.iam.exceptions.IamGroupExists;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.JwtValidator;
import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.JsonOverHttpClientBuilder;
import io.continual.metrics.MetricsCatalog;
import io.continual.util.collections.ShardedExpiringCache;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.standards.HttpStatusCodes;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteAuthDb
implements IamDb<Identity, Group> {
    private final JsonOverHttpClient fIamClient;
    private final String fBaseUrl;
    private final String fAuthUser;
    private final String fAuthPassword;
    private final ShardedExpiringCache<String, CacheEntry> fKnownAuths;

    public RemoteAuthDb(JSONObject config) throws Builder.BuildFailure {
        this.fIamClient = new JsonOverHttpClientBuilder().readJsonConfig(config).build();
        String baseUrl = config.optString("baseUrl", "https://auth.continual.io/");
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.fBaseUrl = baseUrl;
        this.fAuthUser = config.optString("authUser", null);
        this.fAuthPassword = config.optString("authPassword", null);
        if (this.fAuthUser == null || this.fAuthPassword == null) {
            throw new Builder.BuildFailure("Missing authUser or authPassword");
        }
        this.fKnownAuths = new ShardedExpiringCache.Builder().named("RemoteAuths").cachingFor((long)config.optInt("cacheTimeSeconds", 900), TimeUnit.SECONDS).build();
    }

    public void populateMetrics(MetricsCatalog metrics) {
    }

    @Override
    public void close() {
        this.fIamClient.close();
    }

    @Override
    public List<String> findUsers(String startingWith) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Identity createUser(String userId) throws IamIdentityExists, IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Identity createAnonymousUser() throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void deleteUser(String userId) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void addAlias(String userId, String alias) throws IamSvcException, IamBadRequestException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void removeAlias(String alias) throws IamBadRequestException, IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Collection<String> getAliasesFor(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public boolean completePasswordReset(String tag, String newPassword) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public ApiKey loadApiKeyRecord(String apiKey) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void restoreApiKey(ApiKey key) throws IamIdentityDoesNotExist, IamBadRequestException, IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void addJwtValidator(JwtValidator v) {
    }

    @Override
    public Collection<String> getAllUsers() throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Map<String, Identity> loadAllUsers() throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public boolean userExists(String userId) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public boolean userOrAliasExists(String userIdOrAlias) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Identity loadUser(String userId) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Identity loadUserOrAlias(String userIdOrAlias) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public String createJwtToken(Identity ii, long duration, TimeUnit durationUnits) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void invalidateJwtToken(String jwtToken) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Identity authenticate(UsernamePasswordCredential upc) throws IamSvcException {
        String password;
        String username = upc.getUsername();
        CacheEntry ce = (CacheEntry)this.fKnownAuths.read((Object)username, arg_0 -> RemoteAuthDb.lambda$authenticate$0(password = upc.getPassword(), arg_0));
        if (ce != null) {
            return ce.getIdentity();
        }
        try (JsonOverHttpClient.HttpResponse resp = this.fIamClient.newRequest().onPath(this.makePath("/auth/login")).post(new JSONObject().put("username", (Object)username).put("password", (Object)password));){
            int code = resp.getCode();
            switch (code) {
                case 200: {
                    RemoteIdentity id = new RemoteIdentity(username);
                    CacheEntry newCe = new CacheEntry(password, id);
                    this.fKnownAuths.write((Object)username, (Object)newCe);
                    RemoteIdentity remoteIdentity = newCe.getIdentity();
                    return remoteIdentity;
                }
                case 401: {
                    CacheEntry newCe = new CacheEntry(password, null);
                    this.fKnownAuths.write((Object)username, (Object)newCe);
                    Identity identity = null;
                    return identity;
                }
            }
            throw new IamSvcException("Unexpected response from Auth service");
        }
        catch (JsonOverHttpClient.HttpServiceException | JSONException e) {
            throw new IamSvcException(e);
        }
    }

    @Override
    public Identity authenticate(ApiKeyCredential akc) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Identity authenticate(JwtCredential jwt) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Group createGroup(String groupDesc) throws IamGroupExists, IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Group createGroup(String groupId, String groupDesc) throws IamGroupExists, IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void addUserToGroup(String groupId, String userId) throws IamSvcException, IamIdentityDoesNotExist, IamGroupDoesNotExist {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void removeUserFromGroup(String groupId, String userId) throws IamSvcException, IamIdentityDoesNotExist, IamGroupDoesNotExist {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Set<String> getUsersGroups(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Set<String> getUsersInGroup(String groupId) throws IamSvcException, IamGroupDoesNotExist {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Collection<String> getAllGroups() throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public Group loadGroup(String id) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public AccessControlList getAclFor(Resource resource) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public boolean canUser(String id, Resource resource, String operation) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public String createTag(String userId, String appTagType, long duration, TimeUnit durationTimeUnit, String nonce) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public String getUserIdForTag(String tag) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void removeMatchingTag(String userId, String appTagType) throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void sweepExpiredTags() throws IamSvcException {
        throw new IamSvcException("Not implemented");
    }

    @Override
    public void onAclUpdate(AccessControlList accessControlList) {
    }

    private String makePath(String ... parts) {
        StringBuilder sb = new StringBuilder(this.fBaseUrl);
        for (String part : parts) {
            if (!part.startsWith("/")) {
                sb.append("/");
            }
            if (part.endsWith("/")) {
                part = part.substring(0, part.length() - 1);
            }
            sb.append(part);
        }
        return sb.toString();
    }

    private static /* synthetic */ boolean lambda$authenticate$0(String password, CacheEntry entry) {
        return entry.usedPassword(password);
    }

    private class CacheEntry {
        private final Integer fPassword;
        private final RemoteIdentity fIdentity;

        public CacheEntry(String password, RemoteIdentity id) {
            this.fPassword = this.hash(password);
            this.fIdentity = id;
        }

        public RemoteIdentity getIdentity() {
            return this.fIdentity;
        }

        public boolean usedPassword(String password) {
            return this.fPassword == null && password == null || this.fPassword.equals(this.hash(password));
        }

        private final Integer hash(String val) {
            return val == null ? null : Integer.valueOf(val.hashCode());
        }
    }

    private class RemoteIdentity
    implements Identity {
        private final String fUsername;
        private JSONObject fBackingData = null;

        public RemoteIdentity(String username) {
            this.fUsername = username;
            this.fBackingData = null;
        }

        @Override
        public String getId() {
            return this.fUsername;
        }

        @Override
        public void reload() throws IamSvcException {
            block9: {
                try (JsonOverHttpClient.HttpResponse resp = RemoteAuthDb.this.fIamClient.newRequest().onPath(RemoteAuthDb.this.makePath("users", this.fUsername)).asUser(new HttpUsernamePasswordCredentials(RemoteAuthDb.this.fAuthUser, RemoteAuthDb.this.fAuthPassword)).get();){
                    if (HttpStatusCodes.isSuccess((int)resp.getCode())) {
                        this.fBackingData = resp.getBody();
                        break block9;
                    }
                    throw new IamSvcException("Unexpected response from Auth service while loading user record.");
                }
                catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException e) {
                    throw new IamSvcException(e);
                }
            }
        }

        @Override
        public String getUserData(String key) throws IamSvcException {
            JSONObject dataBlock;
            JSONObject backingData = this.getBackingData();
            if (backingData != null && (dataBlock = backingData.optJSONObject("data")) != null) {
                return dataBlock.optString(key);
            }
            return null;
        }

        @Override
        public void putUserData(String key, String val) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public void removeUserData(String key) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public Map<String, String> getAllUserData() throws IamSvcException {
            JSONObject dataBlock;
            JSONObject backingData = this.getBackingData();
            if (backingData != null && (dataBlock = backingData.optJSONObject("data")) != null) {
                return JsonVisitor.objectToMap((JSONObject)dataBlock);
            }
            return new HashMap<String, String>();
        }

        @Override
        public boolean isEnabled() throws IamSvcException {
            JSONObject backingData = this.getBackingData();
            if (backingData != null) {
                return backingData.optBoolean("enabled", true);
            }
            return true;
        }

        @Override
        public void enable(boolean enable) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public void setPassword(String password) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public String requestPasswordReset(long secondsUntilExpire, String nonce) throws IamSvcException, IamBadRequestException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public ApiKey createApiKey() throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public Collection<String> loadApiKeysForUser() throws IamSvcException {
            JSONObject backingData = this.getBackingData();
            if (backingData != null) {
                return JsonVisitor.arrayToList((JSONArray)backingData.optJSONArray("apiKeys"));
            }
            return new LinkedList<String>();
        }

        @Override
        public void deleteApiKey(ApiKey key) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public Set<String> getGroupIds() throws IamSvcException {
            JSONObject backingData = this.getBackingData();
            if (backingData != null) {
                return new TreeSet<String>(JsonVisitor.arrayToList((JSONArray)backingData.optJSONArray("groups")));
            }
            return new TreeSet<String>();
        }

        @Override
        public Collection<Group> getGroups() throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        @Override
        public Group getGroup(String groupId) throws IamSvcException {
            throw new IamSvcException("Not implemented");
        }

        private JSONObject getBackingData() throws IamSvcException {
            if (this.fBackingData == null) {
                this.reload();
            }
            return this.fBackingData;
        }
    }
}

