/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.jsondoc;

import io.continual.builder.Builder;
import io.continual.iam.IamServiceManager;
import io.continual.iam.access.AccessDb;
import io.continual.iam.access.AccessManager;
import io.continual.iam.identity.IdentityDb;
import io.continual.iam.identity.IdentityManager;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.jsondoc.JsonDocDb;
import io.continual.iam.tags.TagManager;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import org.json.JSONObject;

public class SimpleDocDbSvc
extends SimpleService
implements IamServiceManager<CommonJsonIdentity, CommonJsonGroup> {
    private final JSONObject fDbJson;
    private final JsonDocDb fDb;

    public SimpleDocDbSvc(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fDbJson = config.optJSONObject("db");
        if (this.fDbJson == null) {
            throw new Builder.BuildFailure("No IAM db provided.");
        }
        this.fDb = new JsonDocDb(this.fDbJson);
    }

    @Override
    public IdentityDb<CommonJsonIdentity> getIdentityDb() {
        return this.fDb;
    }

    @Override
    public AccessDb<CommonJsonGroup> getAccessDb() {
        return this.fDb;
    }

    @Override
    public IdentityManager<CommonJsonIdentity> getIdentityManager() {
        return this.fDb;
    }

    @Override
    public AccessManager<CommonJsonGroup> getAccessManager() {
        return this.fDb;
    }

    @Override
    public TagManager getTagManager() {
        return this.fDb;
    }
}

