/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.identity.ApiKey;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonJsonApiKey
implements ApiKey {
    private final String fId;
    private final String fSecret;
    private final String fUserId;
    private final long fCreateTsMs;
    private static final long kDefaultTs = 0L;

    public static JSONObject initialize(String secret, String userId) {
        return new JSONObject().put("userId", (Object)userId).put("secret", (Object)secret);
    }

    public CommonJsonApiKey(String id, JSONObject record) {
        this.fId = id;
        this.fUserId = record.optString("userId", record.optString("user", null));
        this.fSecret = record.getString("secret");
        this.fCreateTsMs = record.optLong("createMs", 0L);
        if (this.fUserId == null) {
            throw new JSONException("Expected either userId or user in API key record.");
        }
    }

    @Override
    public String getKey() {
        return this.fId;
    }

    @Override
    public String getSecret() {
        return this.fSecret;
    }

    @Override
    public String getUserId() {
        return this.fUserId;
    }

    @Override
    public long getCreationTimestamp() {
        return this.fCreateTsMs;
    }
}

