/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.IamAuthLog;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.impl.common.HeaderReader;
import io.continual.iam.impl.common.SignedContentReader;
import org.json.JSONObject;

public class ApiKeyAuthHelper {
    public static final String kSetting_AuthLineHeader = "api.headers.auth";
    public static final String kSetting_DateLineHeader = "api.headers.date";
    public static final String kSetting_MagicLineHeader = "api.headers.magic";
    public static final String kDefault_AuthLineHeader = "X-Auth";
    public static final String kDefault_DateLineHeader = "X-Date";
    public static final String kDefault_MagicLineHeader = "X-Magic";

    public static ApiKeyCredential readApiKeyCredential(JSONObject settings, HeaderReader hr, String serviceName) {
        String authHeader = settings.optString(kSetting_AuthLineHeader, kDefault_AuthLineHeader);
        String authLine = hr.getFirstHeader(authHeader);
        if (authLine == null) {
            IamAuthLog.debug("No " + authHeader + " header");
            return null;
        }
        String signedContent = SignedContentReader.getSignedContent(hr.getFirstHeader("Date"), hr.getFirstHeader(settings.optString(kSetting_DateLineHeader, kDefault_DateLineHeader)), hr.getFirstHeader(settings.optString(kSetting_MagicLineHeader, kDefault_MagicLineHeader)), serviceName);
        if (signedContent == null) {
            return null;
        }
        int colon = authLine.indexOf(58);
        if (colon == -1) {
            IamAuthLog.info(authHeader + " is malformed");
            return null;
        }
        String apiKey = authLine.substring(0, colon);
        String signature = authLine.substring(colon + 1);
        IamAuthLog.info("key: " + apiKey + "; signature: " + signature);
        return new ApiKeyCredential(apiKey, signedContent, signature);
    }
}

