/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.credentials;

import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtCredential {
    private final String fOrigToken;
    private final String fSubject;
    private final String fIssuer;
    private final TreeSet<String> fAudience;
    private final long fExpiresSec;
    private final String fSignedContent;
    private final String fSignature;
    private final String fAlgo;
    private static TreeSet<String> skSignatureAlgos = new TreeSet();
    private static final Logger log;

    public static JwtCredential fromHeader(String authHeader) throws InvalidJwtToken {
        String[] parts;
        if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
            return new JwtCredential(parts[1]);
        }
        throw new InvalidJwtToken("The auth header value doesn't start with Bearer.");
    }

    public JwtCredential(String jwtToken) throws InvalidJwtToken {
        this(jwtToken, true);
    }

    public JwtCredential(String jwtToken, boolean checkExpired) throws InvalidJwtToken {
        this.fOrigToken = jwtToken;
        String[] parts = jwtToken.split("\\.");
        if (parts.length != 3) {
            throw new InvalidJwtToken("The JWT token doesn't have three segments.");
        }
        this.fSignedContent = parts[0] + "." + parts[1];
        log.info("signed data: {}", (Object)this.fSignedContent);
        this.fSignature = parts[2];
        try {
            String headerStr = new String(TypeConvertor.base64UrlDecode((String)parts[0]));
            JSONObject header = new JSONObject(headerStr);
            String type = header.getString("typ");
            this.fAlgo = header.getString("alg");
            if (!type.equals("JWT") || !skSignatureAlgos.contains(this.fAlgo)) {
                log.info("Unrecognized type or algo on JWT: " + type + " / " + this.fAlgo);
                throw new InvalidJwtToken("Token type is not JWT or we don't know algo [" + this.fAlgo + "]");
            }
            String payloadStr = new String(TypeConvertor.base64UrlDecode((String)parts[1]));
            JSONObject payload = new JSONObject(payloadStr);
            log.debug("Unpacking JWT: {}", (Object)payloadStr);
            this.fIssuer = payload.getString("iss");
            this.fAudience = new TreeSet();
            JSONArray aud = payload.optJSONArray("aud");
            if (aud != null) {
                this.fAudience.addAll(JsonVisitor.arrayToList((JSONArray)aud));
            } else {
                this.fAudience.add(payload.getString("aud"));
            }
            this.fExpiresSec = payload.getLong("exp");
            long nowSec = Clock.now() / 1000L;
            if (checkExpired && this.fExpiresSec < nowSec) {
                log.info("Expired token. exp=" + this.fExpiresSec + "; currently " + nowSec);
                throw new InvalidJwtToken("The token is expired.");
            }
            this.fSubject = payload.getString("sub");
            if (this.fSubject.length() == 0) {
                log.info("No subject on token");
                throw new InvalidJwtToken("The token has no subject.");
            }
        }
        catch (JSONException e) {
            log.info("Couldn't parse token.");
            throw new InvalidJwtToken("The token text is not JSON.");
        }
    }

    public String toBearerString() {
        return this.fOrigToken;
    }

    public String getSignedContent() {
        return this.fSignedContent;
    }

    public String getSignature() {
        return this.fSignature;
    }

    public String toString() {
        return "JWT for " + this.fSubject;
    }

    public String getSubject() {
        return this.fSubject;
    }

    public String getIssuer() {
        return this.fIssuer;
    }

    public boolean isForAudience(String aud) {
        return this.fAudience.contains(aud);
    }

    public String getSigningAlgorithm() {
        return this.fAlgo;
    }

    public long getExpiration() {
        return this.fExpiresSec;
    }

    public boolean isExpired() {
        return this.getExpiration() < Clock.now() / 1000L;
    }

    static {
        skSignatureAlgos.add("HS256");
        skSignatureAlgos.add("RS256");
        log = LoggerFactory.getLogger(JwtCredential.class);
    }

    public static class InvalidJwtToken
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidJwtToken(String msg) {
            super(msg);
        }
    }
}

