/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.access;

import io.continual.util.data.json.JsonVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccessControlEntry {
    public static final String kAnyUser = "*";
    public static final String kAnyOperation = "*";
    public static final String kOwner = "~owner~";
    private final String fWho;
    private final TreeSet<String> fOperations;
    private final Access fPermission;

    public static Builder builder() {
        return new Builder();
    }

    public AccessControlEntry(AccessControlEntry that) {
        this.fWho = that.fWho;
        this.fPermission = that.fPermission;
        this.fOperations = new TreeSet();
        for (String op : that.fOperations) {
            this.fOperations.add(op);
        }
    }

    public AccessControlEntry(String userOrGroupId, Access p, String operation) {
        this(userOrGroupId, p, new String[]{operation});
    }

    public AccessControlEntry(String userOrGroupId, Access p, String[] operations) {
        this.fWho = userOrGroupId;
        this.fOperations = new TreeSet();
        this.fPermission = p;
        for (String op : operations) {
            this.fOperations.add(op);
        }
    }

    public AccessControlEntry(String userOrGroupId, Access p, Collection<String> a) {
        this.fWho = userOrGroupId;
        this.fPermission = p;
        this.fOperations = new TreeSet<String>(a);
        if (this.fWho == null) {
            throw new IllegalArgumentException("ACL entry requires a subject.");
        }
        if (this.fPermission == null) {
            throw new IllegalArgumentException("ACL entry requires a permission.");
        }
        if (this.fOperations.size() == 0) {
            throw new IllegalArgumentException("ACL entry requires at least one operation.");
        }
    }

    public AccessControlEntry clone() {
        return new AccessControlEntry(this.fWho, this.fPermission, this.fOperations);
    }

    public Access check(String userId, Set<String> groups, boolean isOwner, String op) {
        if (this.fWho.equals("*") || this.fWho.equals(userId) || groups != null && groups.contains(this.fWho) || isOwner && this.fWho.equals(kOwner)) {
            for (String listedOp : this.fOperations) {
                if (!listedOp.equalsIgnoreCase(op) && !listedOp.equals("*")) continue;
                return this.fPermission;
            }
        }
        return null;
    }

    public String getSubject() {
        return this.fWho;
    }

    public Access getPermission() {
        return this.fPermission;
    }

    public Set<String> getOperationSet() {
        return new TreeSet<String>((SortedSet<String>)this.fOperations);
    }

    public String[] getOperations() {
        return this.fOperations.toArray(new String[this.fOperations.size()]);
    }

    public int getOperationCount() {
        return this.fOperations.size();
    }

    public boolean removeOperation(String op) {
        return this.fOperations.remove(op);
    }

    public String toString() {
        return this.serialize().toString();
    }

    public JSONObject serialize() {
        JSONArray ops = new JSONArray();
        for (String op : this.fOperations) {
            ops.put((Object)op);
        }
        return new JSONObject().put("w", (Object)this.fWho).put("a", (Object)(this.fPermission == Access.PERMIT ? "p" : "d")).put("o", (Object)ops);
    }

    public static AccessControlEntry deserialize(JSONObject o) {
        return AccessControlEntry.builder().forSubject(AccessControlEntry.readString(o, "w", "who")).withAccess(Access.deserialize(AccessControlEntry.readString(o, "a", "access"))).operations(JsonVisitor.arrayToList((JSONArray)AccessControlEntry.readArray(o, "o", "operations"))).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fOperations, this.fPermission, this.fWho});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessControlEntry other = (AccessControlEntry)obj;
        return Objects.equals(this.fOperations, other.fOperations) && this.fPermission == other.fPermission && Objects.equals(this.fWho, other.fWho);
    }

    private AccessControlEntry(Builder b) {
        this(b.fUserOrGroupId, b.fAccess, b.fOps);
    }

    private static String readString(JSONObject o, String ... keys) {
        for (String key : keys) {
            String v = o.optString(key, null);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private static JSONArray readArray(JSONObject o, String ... keys) {
        for (String key : keys) {
            JSONArray v = o.optJSONArray(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static class Builder {
        private String fUserOrGroupId = null;
        private Access fAccess = Access.PERMIT;
        private LinkedList<String> fOps = new LinkedList();

        public Builder forSubject(String userOrGroupId) {
            this.fUserOrGroupId = userOrGroupId;
            return this;
        }

        public Builder forAllUsers() {
            return this.forSubject("*");
        }

        public Builder forOwner() {
            return this.forSubject(AccessControlEntry.kOwner);
        }

        public Builder permit() {
            return this.withAccess(Access.PERMIT);
        }

        public Builder deny() {
            return this.withAccess(Access.DENY);
        }

        public Builder withAccess(Access a) {
            this.fAccess = a;
            return this;
        }

        public Builder operation(String op) {
            this.fOps.add(op);
            return this;
        }

        public Builder operations(String ... ops) {
            for (String op : ops) {
                this.fOps.add(op);
            }
            return this;
        }

        public Builder operations(Collection<String> ops) {
            this.fOps.addAll(ops);
            return this;
        }

        public Builder forAnyOperation() {
            return this.operation("*");
        }

        public AccessControlEntry build() {
            return new AccessControlEntry(this);
        }
    }

    public static enum Access {
        PERMIT,
        DENY;


        public static Access deserialize(String val) {
            if ((val = val.trim().toUpperCase()).equals("P")) {
                val = PERMIT.toString();
            }
            if (val.equals("D")) {
                val = DENY.toString();
            }
            return Access.valueOf(val);
        }
    }
}

