/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.log4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Table;
import io.contek.tusk.TuskUtils;
import io.contek.tusk.log4j.ILevelMapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.logging.log4j.Level;

@Immutable
public final class TuskLoggingConfig {
    private final String appName;
    private final Table table;
    private final BatchingConfig batching;
    private final String appColumn;
    private final String levelColumn;
    private final String loggerColumn;
    private final String lineColumn;
    private final String errorColumn;
    private final String messageColumn;
    private final String stacktraceColumn;
    private final Level logLevel;
    private final ImmutableMap<String, String> contextColumns;
    private final ILevelMapper mapper;

    private TuskLoggingConfig(String appName, Table table, BatchingConfig batching, String appColumn, String levelColumn, @Nullable String loggerColumn, @Nullable String lineColumn, @Nullable String errorColumn, @Nullable String messageColumn, @Nullable String stacktraceColumn, @Nullable Level logLevel, ImmutableMap<String, String> contextColumns, ILevelMapper mapper) {
        this.appName = appName;
        this.table = table;
        this.batching = batching;
        this.levelColumn = levelColumn;
        this.appColumn = appColumn;
        this.loggerColumn = loggerColumn;
        this.lineColumn = lineColumn;
        this.errorColumn = errorColumn;
        this.messageColumn = messageColumn;
        this.stacktraceColumn = stacktraceColumn;
        this.logLevel = logLevel;
        this.contextColumns = contextColumns;
        this.mapper = mapper;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppName() {
        return this.appName;
    }

    public Table getTable() {
        return this.table;
    }

    public BatchingConfig getBatching() {
        return this.batching;
    }

    public String getAppColumn() {
        return this.appColumn;
    }

    public String getLevelColumn() {
        return this.levelColumn;
    }

    @Nullable
    public String getLoggerColumn() {
        return this.loggerColumn;
    }

    @Nullable
    public String getLineColumn() {
        return this.lineColumn;
    }

    @Nullable
    public String getErrorColumn() {
        return this.errorColumn;
    }

    @Nullable
    public String getMessageColumn() {
        return this.messageColumn;
    }

    @Nullable
    public String getStacktraceColumn() {
        return this.stacktraceColumn;
    }

    @Nullable
    public Level getLogLevel() {
        return this.logLevel;
    }

    public ImmutableMap<String, String> getContextColumns() {
        return this.contextColumns;
    }

    public ILevelMapper getMapper() {
        return this.mapper;
    }

    @NotThreadSafe
    public static final class Builder {
        private String appName;
        private Table table;
        private BatchingConfig batching = BatchingConfig.forDuration((Duration)Duration.ofSeconds(10L), (Integer)50000);
        private String appColumn = "app";
        private String levelColumn = "level";
        private String loggerColumn = "logger";
        private String lineColumn = "line";
        private String errorColumn = "error";
        private String messageColumn = "message";
        private String stacktraceColumn = "stacktrace";
        private String logLevel = "INFO";
        private Map<String, String> contextColumns = new HashMap<String, String>();
        private ILevelMapper levelMapper = ILevelMapper.getDefault();

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setTable(Table.Builder table) {
            return this.setTable(table.build());
        }

        public Builder setTable(Table table) {
            this.table = table;
            return this;
        }

        public Builder setBatching(BatchingConfig batching) {
            this.batching = batching;
            return this;
        }

        public Builder setAppColumn(String appColumn) {
            this.appColumn = appColumn;
            return this;
        }

        public Builder setLevelColumn(String levelColumn) {
            this.levelColumn = levelColumn;
            return this;
        }

        public Builder setLoggerColumn(@Nullable String loggerColumn) {
            this.loggerColumn = loggerColumn;
            return this;
        }

        public Builder setLineColumn(@Nullable String lineColumn) {
            this.lineColumn = lineColumn;
            return this;
        }

        public Builder setErrorColumn(@Nullable String errorColumn) {
            this.errorColumn = errorColumn;
            return this;
        }

        public Builder setMessageColumn(@Nullable String messageColumn) {
            this.messageColumn = messageColumn;
            return this;
        }

        public Builder setStacktraceColumn(@Nullable String stacktraceColumn) {
            this.stacktraceColumn = stacktraceColumn;
            return this;
        }

        public Builder addContextColumn(String keyAndColumn) {
            return this.addContextColumn(keyAndColumn, keyAndColumn);
        }

        public Builder addContextColumn(String key, String column) {
            this.contextColumns.put(key, column);
            return this;
        }

        public Builder addContextColumns(Map<String, String> contextColumns) {
            this.contextColumns.putAll(contextColumns);
            return this;
        }

        public Builder setContextColumns(Map<String, String> contextColumns) {
            this.contextColumns = contextColumns;
            return this;
        }

        public Builder setLogLevel(@Nullable String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setLevelMapper(ILevelMapper levelMapper) {
            this.levelMapper = levelMapper;
            return this;
        }

        public TuskLoggingConfig build() {
            Preconditions.checkNotNull((Object)this.table);
            Preconditions.checkNotNull((Object)this.batching);
            Preconditions.checkNotNull((Object)this.levelColumn);
            Preconditions.checkNotNull((Object)this.appColumn);
            Preconditions.checkNotNull(this.contextColumns);
            Preconditions.checkNotNull((Object)this.levelMapper);
            if (this.appName == null) {
                this.appName = TuskUtils.getAppName((String)this.appColumn);
            }
            return new TuskLoggingConfig(this.appName, this.table, this.batching, this.appColumn, this.levelColumn, this.loggerColumn, this.lineColumn, this.errorColumn, this.messageColumn, this.stacktraceColumn, this.logLevel == null ? null : Level.getLevel((String)this.logLevel), (ImmutableMap<String, String>)ImmutableMap.copyOf(this.contextColumns), this.levelMapper);
        }

        private Builder() {
        }
    }
}

