/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.log4j;

import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.logging.log4j.Level;

@Immutable
public interface ILevelMapper
extends Function<Level, Byte> {
    public static ILevelMapper getDefault() {
        return Default.INSTANCE;
    }

    @Immutable
    public static final class Default
    implements ILevelMapper {
        private static final Default INSTANCE = new Default();

        @Override
        public Byte apply(Level level) {
            int value = level.intLevel() / 100;
            if (value > 127) {
                return (byte)-1;
            }
            return (byte)value;
        }

        private Default() {
        }
    }
}

