/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.log4j;

import com.google.common.base.Throwables;
import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Metric;
import io.contek.tusk.Table;
import io.contek.tusk.log4j.TuskLoggingConfig;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Immutable
public final class TuskAppender
extends AbstractAppender {
    private final Metric metric;
    private final TuskLoggingConfig config;

    TuskAppender(TuskLoggingConfig config, String appenderName, @Nullable Filter filter, boolean ignoreExceptions, @Nullable Property[] properties) {
        super(appenderName, filter, (Layout)new MessageLayout(), ignoreExceptions, properties);
        this.metric = Metric.metric((Table)config.getTable(), (BatchingConfig)config.getBatching());
        this.config = config;
    }

    public void append(LogEvent event) {
        Throwable t;
        String value;
        Metric.EntryWriter writer = this.metric.newEntry();
        Level level = event.getLevel();
        writer.putInt8(this.config.getLevelColumn(), ((Byte)this.config.getMapper().apply(level)).byteValue());
        writer.putString(this.config.getAppColumn(), this.config.getAppName());
        if (this.config.getLoggerColumn() != null) {
            String name = event.getLoggerName();
            value = name == null ? "" : name;
            writer.putString(this.config.getLoggerColumn(), value);
        }
        if (this.config.getLineColumn() != null) {
            t = event.getThrown();
            StackTraceElement[] stack = t == null ? null : t.getStackTrace();
            int value2 = stack == null || stack.length < 1 ? 0 : stack[0].getLineNumber();
            writer.putUInt32(this.config.getLineColumn(), value2);
        }
        if (this.config.getErrorColumn() != null) {
            t = event.getThrown();
            value = t == null ? "" : t.getClass().getSimpleName();
            writer.putString(this.config.getErrorColumn(), value);
        }
        if (this.config.getMessageColumn() != null) {
            String message = event.getMessage().getFormattedMessage();
            value = message == null ? "" : message;
            writer.putString(this.config.getMessageColumn(), value);
        }
        if (this.config.getStacktraceColumn() != null) {
            t = event.getThrown();
            value = t == null ? "" : Throwables.getStackTraceAsString((Throwable)t);
            writer.putString(this.config.getStacktraceColumn(), value);
        }
        ReadOnlyStringMap context = event.getContextData();
        for (Map.Entry contextTag : context.toMap().entrySet()) {
            String contextKey = (String)contextTag.getKey();
            String contextValue = (String)contextTag.getValue();
            String mappedColumnName = (String)this.config.getContextColumns().get((Object)contextKey);
            if (mappedColumnName == null) {
                mappedColumnName = contextKey;
            }
            writer.putString(mappedColumnName, contextValue);
        }
        writer.write();
    }
}

