/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.log4j;

import com.google.common.base.Preconditions;
import io.contek.tusk.Table;
import io.contek.tusk.log4j.TuskAppender;
import io.contek.tusk.log4j.TuskLoggingConfig;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;

@Immutable
public final class TuskLogging {
    public static void init(String table) {
        TuskLogging.init(null, table);
    }

    public static void init(@Nullable String database, String table) {
        TuskLogging.init(Table.newBuilder().setDatabase(database).setName(table).build());
    }

    public static void init(Table table) {
        TuskLogging.init(TuskLoggingConfig.newBuilder().setTable(table));
    }

    public static void init(TuskLoggingConfig.Builder config) {
        TuskLogging.init(config.build());
    }

    public static void init(TuskLoggingConfig config) {
        TuskLogging.customize().setConfig(config).complete();
    }

    public static Customizer customize() {
        return new Customizer();
    }

    private static void attach(TuskAppender appender) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        LoggerConfig root = config.getRootLogger();
        appender.start();
        root.addAppender((Appender)appender, null, null);
        loggerContext.updateLoggers();
    }

    private TuskLogging() {
    }

    @NotThreadSafe
    public static final class Customizer {
        private TuskLoggingConfig config;
        private String appenderName = "Tusk";
        private Filter filter = null;
        private boolean ignoreExceptions = true;
        private Property[] properties = null;

        public Customizer setConfig(TuskLoggingConfig.Builder config) {
            return this.setConfig(config.build());
        }

        public Customizer setConfig(TuskLoggingConfig config) {
            this.config = config;
            return this;
        }

        public Customizer setAppenderName(String appenderName) {
            this.appenderName = appenderName;
            return this;
        }

        public Customizer setFilter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        public Customizer setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Customizer setProperties(@Nullable Property[] properties) {
            this.properties = properties;
            return this;
        }

        public void complete() {
            Preconditions.checkNotNull((Object)this.config);
            Preconditions.checkNotNull((Object)this.appenderName);
            TuskLogging.attach(new TuskAppender(this.config, this.appenderName, this.filter, this.ignoreExceptions, this.properties));
        }

        private Customizer() {
        }
    }
}

