package io.contek.tusk.log4j;

import org.apache.logging.log4j.Level;

import javax.annotation.concurrent.Immutable;
import java.util.function.Function;

@Immutable
public interface ILevelMapper extends Function<Level, Byte> {

  static ILevelMapper getDefault() {
    return Default.INSTANCE;
  }

  @Immutable
  final class Default implements ILevelMapper {

    private static final Default INSTANCE = new Default();

    @Override
    public Byte apply(Level level) {
      int value = level.intLevel() / 100;
      if (value > Byte.MAX_VALUE) {
        return -1;
      }
      return (byte) value;
    }

    private Default() {}
  }
}
