/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.heartbeat;

import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Table;
import io.contek.tusk.TuskUtils;
import io.contek.tusk.heartbeat.BadHeartbeatPeriodException;
import io.contek.tusk.heartbeat.BadTimeoutException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class TuskHeartbeatConfig {
    private final String appName;
    private final Table table;
    private final Duration heartbeatPeriod;
    private final Duration timeout;
    private final BatchingConfig batching;
    private final String appColumn;
    private final String taskColumn;
    private final String sequenceColumn;
    private final String expiryColumn;

    private TuskHeartbeatConfig(String appName, Table table, Duration heartbeatPeriod, Duration timeout, BatchingConfig batching, String appColumn, String taskColumn, String sequenceColumn, String expiryColumn) {
        this.appName = appName;
        this.table = table;
        this.heartbeatPeriod = heartbeatPeriod;
        this.timeout = timeout;
        this.batching = batching;
        this.appColumn = appColumn;
        this.taskColumn = taskColumn;
        this.sequenceColumn = sequenceColumn;
        this.expiryColumn = expiryColumn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppName() {
        return this.appName;
    }

    public Table getTable() {
        return this.table;
    }

    public Duration getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public BatchingConfig getBatching() {
        return this.batching;
    }

    public String getAppColumn() {
        return this.appColumn;
    }

    public String getTaskColumn() {
        return this.taskColumn;
    }

    public String getSequenceColumn() {
        return this.sequenceColumn;
    }

    public String getExpiryColumn() {
        return this.expiryColumn;
    }

    @NotThreadSafe
    public static final class Builder {
        private String appName;
        private Table table;
        private Duration heartbeatPeriod = Duration.ofSeconds(30L);
        private Duration timeout = Duration.ofSeconds(30L);
        private BatchingConfig batching = BatchingConfig.forDuration((Duration)Duration.ofSeconds(5L));
        private String appColumn = "app";
        private String taskColumn = "task";
        private String sequenceColumn = "sequence";
        private String expiryColumn = "expiry";

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setTable(Table.Builder table) {
            return this.setTable(table.build());
        }

        public Builder setTable(Table table) {
            this.table = table;
            return this;
        }

        public Builder setHeartbeatPeriod(Duration heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setBatching(BatchingConfig batching) {
            this.batching = batching;
            return this;
        }

        public Builder setAppColumn(String appColumn) {
            this.appColumn = appColumn;
            return this;
        }

        public Builder setTaskColumn(String taskColumn) {
            this.taskColumn = taskColumn;
            return this;
        }

        public Builder setSequenceColumn(String sequenceColumn) {
            this.sequenceColumn = sequenceColumn;
            return this;
        }

        public Builder setExpiryColumn(String expiryColumn) {
            this.expiryColumn = expiryColumn;
            return this;
        }

        public TuskHeartbeatConfig build() {
            Objects.requireNonNull(this.table);
            Objects.requireNonNull(this.heartbeatPeriod);
            Objects.requireNonNull(this.timeout);
            Objects.requireNonNull(this.batching);
            Objects.requireNonNull(this.appColumn);
            Objects.requireNonNull(this.taskColumn);
            Objects.requireNonNull(this.sequenceColumn);
            Objects.requireNonNull(this.expiryColumn);
            BadHeartbeatPeriodException.checkThrow(this.heartbeatPeriod);
            BadTimeoutException.checkThrow(this.timeout);
            if (this.appName == null) {
                this.appName = TuskUtils.getAppName((String)this.appColumn);
            }
            return new TuskHeartbeatConfig(this.appName, this.table, this.heartbeatPeriod, this.timeout, this.batching, this.appColumn, this.taskColumn, this.sequenceColumn, this.expiryColumn);
        }

        private Builder() {
        }
    }
}

