/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.heartbeat;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Metric;
import io.contek.tusk.Table;
import io.contek.tusk.Tusk;
import io.contek.tusk.heartbeat.BadTaskNameException;
import io.contek.tusk.heartbeat.TuskHeartbeatConfig;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TuskHeartbeatClient {
    static final String MAIN_TASK = "main";
    private static final Logger LOGGER = Logger.getLogger(TuskHeartbeatClient.class.getName());
    private final Metric metric;
    private final TuskHeartbeatConfig config;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Multiset<String> counts = ConcurrentHashMultiset.create();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    private TuskHeartbeatClient(TuskHeartbeatConfig config) {
        this.metric = Metric.metric((Table)config.getTable(), (BatchingConfig)config.getBatching());
        this.config = config;
    }

    public static TuskHeartbeatClient forConfig(TuskHeartbeatConfig config) {
        return new TuskHeartbeatClient(config);
    }

    public void start() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Already started");
        }
        this.scheduler.scheduleAtFixedRate(this::sendMainBeat, 0L, this.config.getHeartbeatPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public void beat(String task, Duration heartbeatPeriod) {
        if (!this.started.get()) {
            throw new IllegalStateException("Client not started");
        }
        BadTaskNameException.checkThrow(task);
        this.sendBeat(task, heartbeatPeriod);
    }

    private void sendMainBeat() {
        try {
            this.sendBeat(MAIN_TASK, this.config.getHeartbeatPeriod());
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unknown Error.", t);
        }
    }

    private void sendBeat(String task, Duration heartbeatPeriod) {
        Clock clock = Tusk.getClock();
        Instant expiry = clock.instant().plus(heartbeatPeriod).plus(this.config.getTimeout()).plus(this.config.getBatching().getPeriod());
        this.metric.newEntry().putString(this.config.getAppColumn(), this.config.getAppName()).putString(this.config.getTaskColumn(), task).putUInt32(this.config.getSequenceColumn(), this.counts.add((Object)task, 1)).putDateTime64(this.config.getExpiryColumn(), expiry).write();
    }
}

