/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.heartbeat;

import io.contek.tusk.Table;
import io.contek.tusk.heartbeat.TuskHeartbeatClient;
import io.contek.tusk.heartbeat.TuskHeartbeatConfig;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TuskHeartbeat {
    private static final AtomicReference<TuskHeartbeatClient> clientHolder = new AtomicReference();

    public static void send(String task, Duration heartbeatPeriod) {
        TuskHeartbeatClient client = clientHolder.get();
        if (client == null) {
            throw new IllegalStateException("Client not configured");
        }
        client.beat(task, heartbeatPeriod);
    }

    public static void init(String table) {
        TuskHeartbeat.init(null, table);
    }

    public static void init(@Nullable String database, String table) {
        TuskHeartbeat.init(Table.newBuilder().setDatabase(database).setName(table).build());
    }

    public static void init(Table table) {
        TuskHeartbeat.init(TuskHeartbeatConfig.newBuilder().setTable(table));
    }

    public static void init(TuskHeartbeatConfig.Builder config) {
        TuskHeartbeat.init(config.build());
    }

    public static void init(TuskHeartbeatConfig config) {
        TuskHeartbeatClient client = TuskHeartbeatClient.forConfig(config);
        client.start();
        TuskHeartbeat.setClient(client);
    }

    public static void setClient(TuskHeartbeatClient client) {
        clientHolder.set(client);
    }

    private TuskHeartbeat() {
    }
}

