/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.heartbeat;

import java.time.Duration;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BadTimeoutException
extends IllegalArgumentException {
    private static final Duration MIN_TIMEOUT = Duration.ofSeconds(1L);

    private BadTimeoutException(Duration timeout) {
        super(String.format("Timeout %s is too small", timeout));
    }

    static void checkThrow(Duration timeout) throws BadTimeoutException {
        if (timeout.compareTo(MIN_TIMEOUT) < 0) {
            throw new BadTimeoutException(timeout);
        }
    }
}

