/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.heartbeat;

import java.time.Duration;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BadHeartbeatPeriodException
extends IllegalArgumentException {
    private static final Duration MIN_HEARTBEAT_PERIOD = Duration.ofSeconds(5L);

    private BadHeartbeatPeriodException(Duration heartbeatPeriod) {
        super(String.format("Heartbeat period %s is too small", heartbeatPeriod));
    }

    static void checkThrow(Duration heartbeatPeriod) throws BadHeartbeatPeriodException {
        if (heartbeatPeriod.compareTo(MIN_HEARTBEAT_PERIOD) < 0) {
            throw new BadHeartbeatPeriodException(heartbeatPeriod);
        }
    }
}

