package io.contek.tusk.heartbeat;

import javax.annotation.concurrent.NotThreadSafe;

import static java.lang.String.format;

@NotThreadSafe
public final class BadTaskNameException extends IllegalArgumentException {

  private BadTaskNameException(String taskName) {
    super(format("Task name %s is illegal", taskName));
  }

  static void checkThrow(String taskName) throws BadTaskNameException {
    if (taskName.equals(TuskHeartbeatClient.MAIN_TASK)) {
      throw new BadTaskNameException(taskName);
    }
  }
}
