package io.contek.tusk.heartbeat;

import javax.annotation.concurrent.NotThreadSafe;
import java.time.Duration;

import static java.lang.String.format;

@NotThreadSafe
public final class BadTimeoutException extends IllegalArgumentException {

  private static final Duration MIN_TIMEOUT = Duration.ofSeconds(1);

  private BadTimeoutException(Duration timeout) {
    super(format("Timeout %s is too small", timeout));
  }

  static void checkThrow(Duration timeout) throws BadTimeoutException {
    if (timeout.compareTo(MIN_TIMEOUT) < 0) {
      throw new BadTimeoutException(timeout);
    }
  }
}
