/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk.counter;

import com.google.common.collect.ImmutableMap;
import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Metric;
import io.contek.tusk.Table;
import io.contek.tusk.counter.TagSet;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class Counter {
    private static final Duration DEFAULT_COUNT_PERIOD = Duration.ofSeconds(15L);
    private static final int DEFAULT_COUNTS_PER_BATCH = 4;
    private final Metric metric;
    private final String countColumn;
    private final Duration countPeriod;
    private final Map<TagSet, Integer> counts = new HashMap<TagSet, Integer>();
    private final AtomicReference<Future<?>> task = new AtomicReference<Object>(null);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    private Counter(Metric metric, String countColumn, Duration countPeriod) {
        this.metric = metric;
        this.countColumn = countColumn;
        this.countPeriod = countPeriod;
    }

    public static Counter counter(String table, String countColumn) {
        return Counter.counter(null, table, countColumn);
    }

    public static Counter counter(@Nullable String database, String table, String countColumn) {
        return Counter.counter(Table.newBuilder().setDatabase(database).setName(table).build(), countColumn);
    }

    public static Counter counter(Table table, String countColumn) {
        return Counter.counter(table, countColumn, DEFAULT_COUNT_PERIOD);
    }

    public static Counter counter(Table table, String countColumn, Duration countPeriod) {
        return Counter.counter(table, countColumn, countPeriod, BatchingConfig.forDuration((Duration)countPeriod.multipliedBy(4L)));
    }

    public static Counter counter(Table table, String countColumn, Duration countPeriod, BatchingConfig batching) {
        return new Counter(Metric.metric((Table)table, (BatchingConfig)batching), countColumn, countPeriod);
    }

    public Tagging withTags() {
        return new Tagging(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void count(TagSet tags, int n) {
        Map<TagSet, Integer> map = this.counts;
        synchronized (map) {
            this.counts.compute(tags, (k, oldValue) -> {
                if (oldValue == null) {
                    return n;
                }
                return oldValue + n;
            });
        }
        this.scheduleIfIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIfIdle() {
        AtomicReference<Future<?>> atomicReference = this.task;
        synchronized (atomicReference) {
            Future<?> future = this.task.get();
            if (future != null && !future.isDone()) {
                return;
            }
            this.schedule();
        }
    }

    private void flushAndSchedule() {
        boolean updated = this.flush();
        if (!updated) {
            return;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        AtomicReference<Future<?>> atomicReference = this.task;
        synchronized (atomicReference) {
            ScheduledFuture<?> future = this.scheduler.schedule(this::flushAndSchedule, this.countPeriod.getSeconds(), TimeUnit.SECONDS);
            this.task.set(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush() {
        HashMap<TagSet, Integer> buffer;
        Map<TagSet, Integer> map = this.counts;
        synchronized (map) {
            if (this.counts.isEmpty()) {
                return false;
            }
            buffer = new HashMap<TagSet, Integer>(this.counts);
            this.counts.clear();
        }
        for (Map.Entry entry : buffer.entrySet()) {
            ImmutableMap<String, String> tags = ((TagSet)entry.getKey()).getTags();
            int count = (Integer)entry.getValue();
            this.metric.newEntry().putAll(tags).putUInt32(this.countColumn, count).write();
        }
        return true;
    }

    @NotThreadSafe
    public static final class Tagging {
        private final Counter counter;
        private final Map<String, String> tags = new HashMap<String, String>();

        private Tagging(Counter counter) {
            this.counter = counter;
        }

        public Tagging put(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Tagging putAll(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public void count() {
            this.count(1);
        }

        public void count(int n) {
            this.counter.count(new TagSet(this.tags), n);
        }
    }
}

