package io.contek.tusk.counter;

import com.google.common.collect.ImmutableMap;

import javax.annotation.concurrent.Immutable;
import java.util.Map;
import java.util.Objects;

@Immutable
final class TagSet {

  private final ImmutableMap<String, String> tags;

  TagSet(Map<String, String> tags) {
    this.tags = ImmutableMap.copyOf(tags);
  }

  ImmutableMap<String, String> getTags() {
    return tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TagSet tagSet = (TagSet) o;
    return tags.equals(tagSet.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tags);
  }
}
